/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.campaignmanagement.Ad;
import com.microsoft.bingads.v12.campaignmanagement.AdEditorialStatus;
import com.microsoft.bingads.v12.campaignmanagement.AdStatus;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BulkAd<T extends Ad>
extends SingleRecordBulkEntity {
    private Long adGroupId;
    private String campaignName;
    private String adGroupName;
    protected T ad;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAd>> MAPPINGS;

    BulkAd() {
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    public Long getAdGroupId() {
        return this.adGroupId;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public T getAd() {
        return this.ad;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public void setAd(T ad) {
        this.ad = ad;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAd, Object>> m = new ArrayList<SimpleBulkMapping<BulkAd, Object>>();
        m.add(new SimpleBulkMapping<BulkAd, String>("Status", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return ((Ad)c.getAd()).getStatus() != null ? ((Ad)c.getAd()).getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setStatus(StringExtensions.parseOptional(v, new Function<String, AdStatus>(){

                    @Override
                    public AdStatus apply(String value) {
                        return AdStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, Long>("Id", new Function<BulkAd, Long>(){

            @Override
            public Long apply(BulkAd c) {
                return ((Ad)c.getAd()).getId();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, Long>("Parent Id", new Function<BulkAd, Long>(){

            @Override
            public Long apply(BulkAd c) {
                return c.getAdGroupId();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                c.setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Campaign", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Ad Group", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Editorial Status", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd t) {
                return ((Ad)t.getAd()).getEditorialStatus() != null ? ((Ad)t.getAd()).getEditorialStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setEditorialStatus(StringExtensions.parseOptional(v, new Function<String, AdEditorialStatus>(){

                    @Override
                    public AdEditorialStatus apply(String value) {
                        return AdEditorialStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Device Preference", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return StringExtensions.toDevicePreferenceBulkString(((Ad)c.getAd()).getDevicePreference());
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setDevicePreference(StringExtensions.parseDevicePreference(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Final Url", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return StringExtensions.writeUrls("; ", ((Ad)c.getAd()).getFinalUrls(), ((Ad)c.getAd()).getId());
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((Ad)c.getAd()).setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Mobile Final Url", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return StringExtensions.writeUrls("; ", ((Ad)c.getAd()).getFinalMobileUrls(), ((Ad)c.getAd()).getId());
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((Ad)c.getAd()).setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Tracking Template", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return StringExtensions.toOptionalBulkString(((Ad)c.getAd()).getTrackingUrlTemplate(), ((Ad)c.getAd()).getId());
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Custom Parameter", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return StringExtensions.toCustomParaBulkString(((Ad)c.getAd()).getUrlCustomParameters(), ((Ad)c.getAd()).getId());
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                try {
                    ((Ad)c.getAd()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAd, String>("Ad Format Preference", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return ((Ad)c.getAd()).getAdFormatPreference();
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setAdFormatPreference(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkAd, String>("Final Url Suffix", new Function<BulkAd, String>(){

            @Override
            public String apply(BulkAd c) {
                return StringExtensions.toOptionalBulkString(((Ad)c.getAd()).getFinalUrlSuffix(), ((Ad)c.getAd()).getId());
            }
        }, new BiConsumer<String, BulkAd>(){

            @Override
            public void accept(String v, BulkAd c) {
                ((Ad)c.getAd()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

