/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v12.campaignmanagement.SitelinkAdExtension;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkSitelinkAdExtension
extends BulkAdExtension<SitelinkAdExtension> {
    private static final List<BulkMapping<BulkSitelinkAdExtension>> MAPPINGS;

    public SitelinkAdExtension getSitelinkAdExtension() {
        return (SitelinkAdExtension)this.getAdExtension();
    }

    public void setSitelinkAdExtension(SitelinkAdExtension SitelinkAdExtension2) {
        this.setAdExtension(SitelinkAdExtension2);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        SitelinkAdExtension extension = new SitelinkAdExtension();
        extension.setType("SitelinkAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdExtension(), "SitelinkAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkSitelinkAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkSitelinkAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Sitelink Extension Destination Url", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return StringExtensions.toOptionalBulkString(c.getSitelinkAdExtension().getDestinationUrl(), c.getSitelinkAdExtension().getId());
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                c.getSitelinkAdExtension().setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Sitelink Extension Description1", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return c.getSitelinkAdExtension().getDescription1();
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                c.getSitelinkAdExtension().setDescription1(v);
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Sitelink Extension Description2", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return c.getSitelinkAdExtension().getDescription2();
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                c.getSitelinkAdExtension().setDescription2(v);
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Sitelink Extension Link Text", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return c.getSitelinkAdExtension().getDisplayText();
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                c.getSitelinkAdExtension().setDisplayText(v);
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Final Url", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return StringExtensions.writeUrls("; ", ((SitelinkAdExtension)c.getAdExtension()).getFinalUrls(), ((SitelinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((SitelinkAdExtension)c.getAdExtension()).setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Mobile Final Url", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return StringExtensions.writeUrls("; ", ((SitelinkAdExtension)c.getAdExtension()).getFinalMobileUrls(), ((SitelinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((SitelinkAdExtension)c.getAdExtension()).setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Tracking Template", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return StringExtensions.toOptionalBulkString(((SitelinkAdExtension)c.getAdExtension()).getTrackingUrlTemplate(), ((SitelinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                ((SitelinkAdExtension)c.getAdExtension()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Custom Parameter", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return StringExtensions.toCustomParaBulkString(((SitelinkAdExtension)c.getAdExtension()).getUrlCustomParameters(), ((SitelinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                try {
                    ((SitelinkAdExtension)c.getAdExtension()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkSitelinkAdExtension, String>("Final Url Suffix", new Function<BulkSitelinkAdExtension, String>(){

            @Override
            public String apply(BulkSitelinkAdExtension c) {
                return StringExtensions.toOptionalBulkString(((SitelinkAdExtension)c.getAdExtension()).getFinalUrlSuffix(), ((SitelinkAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkSitelinkAdExtension>(){

            @Override
            public void accept(String v, BulkSitelinkAdExtension c) {
                ((SitelinkAdExtension)c.getAdExtension()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

