/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v12.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.campaignmanagement.GenderCriterion;
import com.microsoft.bingads.v12.campaignmanagement.GenderType;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupGenderCriterion
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupGenderCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        GenderCriterion genderCriterion = new GenderCriterion();
        adGroupCriterion.setCriterion(genderCriterion);
        adGroupCriterion.getCriterion().setType(GenderCriterion.class.getSimpleName());
        adGroupCriterion.setCriterionBid(bidMultiplier);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), BiddableAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion biddableAdGroupCriterion) {
        this.biddableAdGroupCriterion = biddableAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupGenderCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupGenderCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupGenderCriterion, String>("Status", new Function<BulkAdGroupGenderCriterion, String>(){

            @Override
            public String apply(BulkAdGroupGenderCriterion c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupGenderCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenderCriterion c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupGenderCriterion, Long>("Id", new Function<BulkAdGroupGenderCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupGenderCriterion c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupGenderCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenderCriterion c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupGenderCriterion, Long>("Parent Id", new Function<BulkAdGroupGenderCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupGenderCriterion c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupGenderCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenderCriterion c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupGenderCriterion, String>("Campaign", new Function<BulkAdGroupGenderCriterion, String>(){

            @Override
            public String apply(BulkAdGroupGenderCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupGenderCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenderCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupGenderCriterion, String>("Ad Group", new Function<BulkAdGroupGenderCriterion, String>(){

            @Override
            public String apply(BulkAdGroupGenderCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupGenderCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenderCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupGenderCriterion, String>("Bid Adjustment", new Function<BulkAdGroupGenderCriterion, String>(){

            @Override
            public String apply(BulkAdGroupGenderCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupGenderCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenderCriterion c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupGenderCriterion, String>("Target", new Function<BulkAdGroupGenderCriterion, String>(){

            @Override
            public String apply(BulkAdGroupGenderCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof GenderCriterion) {
                    GenderType genderType = ((GenderCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getGenderType();
                    return genderType == null ? null : genderType.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupGenderCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupGenderCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof GenderCriterion) {
                    ((GenderCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setGenderType(StringExtensions.parseOptional(v, new Function<String, GenderType>(){

                        @Override
                        public GenderType apply(String s) {
                            return GenderType.fromValue(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

