/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v12.bulk.entities.PriceTableRowHelper;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfPriceTableRow;
import com.microsoft.bingads.v12.campaignmanagement.PriceAdExtension;
import com.microsoft.bingads.v12.campaignmanagement.PriceExtensionType;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkPriceAdExtension
extends BulkAdExtension<PriceAdExtension> {
    private static final List<BulkMapping<BulkPriceAdExtension>> MAPPINGS;

    public PriceAdExtension getPriceAdExtension() {
        return (PriceAdExtension)this.getAdExtension();
    }

    public void setPriceAdExtension(PriceAdExtension priceAdExtension) {
        this.setAdExtension(priceAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        PriceAdExtension extension = new PriceAdExtension();
        extension.setType("PriceAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getPriceAdExtension(), "PriceAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkPriceAdExtension, String>("Language", new Function<BulkPriceAdExtension, String>(){

            @Override
            public String apply(BulkPriceAdExtension c) {
                return ((PriceAdExtension)c.getAdExtension()).getLanguage();
            }
        }, new BiConsumer<String, BulkPriceAdExtension>(){

            @Override
            public void accept(String v, BulkPriceAdExtension c) {
                c.getPriceAdExtension().setLanguage(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkPriceAdExtension, String>("Price Extension Type", new Function<BulkPriceAdExtension, String>(){

            @Override
            public String apply(BulkPriceAdExtension c) {
                PriceExtensionType priceExtensionType = c.getPriceAdExtension().getPriceExtensionType();
                return priceExtensionType == null ? null : priceExtensionType.value();
            }
        }, new BiConsumer<String, BulkPriceAdExtension>(){

            @Override
            public void accept(String v, BulkPriceAdExtension c) {
                c.getPriceAdExtension().setPriceExtensionType(StringExtensions.parseOptional(v, new Function<String, PriceExtensionType>(){

                    @Override
                    public PriceExtensionType apply(String s) {
                        return PriceExtensionType.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPriceAdExtension, String>("Tracking Template", new Function<BulkPriceAdExtension, String>(){

            @Override
            public String apply(BulkPriceAdExtension c) {
                return StringExtensions.toOptionalBulkString(((PriceAdExtension)c.getAdExtension()).getTrackingUrlTemplate(), ((PriceAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkPriceAdExtension>(){

            @Override
            public void accept(String v, BulkPriceAdExtension c) {
                ((PriceAdExtension)c.getAdExtension()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkPriceAdExtension, String>("Custom Parameter", new Function<BulkPriceAdExtension, String>(){

            @Override
            public String apply(BulkPriceAdExtension c) {
                return StringExtensions.toCustomParaBulkString(((PriceAdExtension)c.getAdExtension()).getUrlCustomParameters(), ((PriceAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkPriceAdExtension>(){

            @Override
            public void accept(String v, BulkPriceAdExtension c) {
                try {
                    ((PriceAdExtension)c.getAdExtension()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new ComplexBulkMapping<BulkPriceAdExtension>(new BiConsumer<BulkPriceAdExtension, RowValues>(){

            @Override
            public void accept(BulkPriceAdExtension c, RowValues v) {
                PriceAdExtension priceAdExtension = c.getPriceAdExtension();
                if (priceAdExtension == null || priceAdExtension.getTableRows() == null) {
                    return;
                }
                PriceTableRowHelper.addRowValuesFromPriceTableRows(priceAdExtension.getTableRows(), v, priceAdExtension.getId());
            }
        }, new BiConsumer<RowValues, BulkPriceAdExtension>(){

            @Override
            public void accept(RowValues v, BulkPriceAdExtension c) {
                PriceAdExtension priceAdExtension = c.getPriceAdExtension();
                if (priceAdExtension != null) {
                    priceAdExtension.setTableRows(new ArrayOfPriceTableRow());
                    PriceTableRowHelper.addPriceTableRowsFromRowValues(v, priceAdExtension.getTableRows());
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

