/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.BulkAd;
import com.microsoft.bingads.v12.campaignmanagement.AdType;
import com.microsoft.bingads.v12.campaignmanagement.TextAd;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkTextAd
extends BulkAd<TextAd> {
    private static final List<BulkMapping<BulkTextAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getTextAd(), "TextAd");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new TextAd());
        ((TextAd)this.getAd()).setType(AdType.TEXT);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public TextAd getTextAd() {
        return (TextAd)this.ad;
    }

    public void setTextAd(TextAd ad) {
        this.setAd(ad);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkTextAd, String>> m = new ArrayList<SimpleBulkMapping<BulkTextAd, String>>();
        m.add(new SimpleBulkMapping<BulkTextAd, String>("Title", new Function<BulkTextAd, String>(){

            @Override
            public String apply(BulkTextAd c) {
                return ((TextAd)c.getAd()).getTitle();
            }
        }, new BiConsumer<String, BulkTextAd>(){

            @Override
            public void accept(String v, BulkTextAd c) {
                ((TextAd)c.getAd()).setTitle(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkTextAd, String>("Text", new Function<BulkTextAd, String>(){

            @Override
            public String apply(BulkTextAd c) {
                return ((TextAd)c.getAd()).getText();
            }
        }, new BiConsumer<String, BulkTextAd>(){

            @Override
            public void accept(String v, BulkTextAd c) {
                ((TextAd)c.getAd()).setText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkTextAd, String>("Display Url", new Function<BulkTextAd, String>(){

            @Override
            public String apply(BulkTextAd c) {
                return ((TextAd)c.getAd()).getDisplayUrl();
            }
        }, new BiConsumer<String, BulkTextAd>(){

            @Override
            public void accept(String v, BulkTextAd c) {
                ((TextAd)c.getAd()).setDisplayUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkTextAd, String>("Destination Url", new Function<BulkTextAd, String>(){

            @Override
            public String apply(BulkTextAd c) {
                return StringExtensions.toOptionalBulkString(((TextAd)c.getAd()).getDestinationUrl());
            }
        }, new BiConsumer<String, BulkTextAd>(){

            @Override
            public void accept(String v, BulkTextAd c) {
                ((TextAd)c.getAd()).setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

