/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.BulkAd;
import com.microsoft.bingads.v12.campaignmanagement.AdType;
import com.microsoft.bingads.v12.campaignmanagement.ResponsiveSearchAd;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkResponsiveSearchAd
extends BulkAd<ResponsiveSearchAd> {
    private static final List<BulkMapping<BulkResponsiveSearchAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getResponsiveSearchAd(), "ResponsiveSearchAd");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new ResponsiveSearchAd());
        ((ResponsiveSearchAd)this.getAd()).setType(AdType.RESPONSIVE_SEARCH);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public ResponsiveSearchAd getResponsiveSearchAd() {
        return (ResponsiveSearchAd)this.ad;
    }

    public void setResponsiveSearchAd(ResponsiveSearchAd ad) {
        this.setAd(ad);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkResponsiveSearchAd, String>> m = new ArrayList<SimpleBulkMapping<BulkResponsiveSearchAd, String>>();
        m.add(new SimpleBulkMapping<BulkResponsiveSearchAd, String>("Path 1", new Function<BulkResponsiveSearchAd, String>(){

            @Override
            public String apply(BulkResponsiveSearchAd c) {
                return StringExtensions.toOptionalBulkString(((ResponsiveSearchAd)c.getAd()).getPath1());
            }
        }, new BiConsumer<String, BulkResponsiveSearchAd>(){

            @Override
            public void accept(String v, BulkResponsiveSearchAd c) {
                ((ResponsiveSearchAd)c.getAd()).setPath1(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveSearchAd, String>("Path 2", new Function<BulkResponsiveSearchAd, String>(){

            @Override
            public String apply(BulkResponsiveSearchAd c) {
                return StringExtensions.toOptionalBulkString(((ResponsiveSearchAd)c.getAd()).getPath2());
            }
        }, new BiConsumer<String, BulkResponsiveSearchAd>(){

            @Override
            public void accept(String v, BulkResponsiveSearchAd c) {
                ((ResponsiveSearchAd)c.getAd()).setPath2(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveSearchAd, String>("Domain", new Function<BulkResponsiveSearchAd, String>(){

            @Override
            public String apply(BulkResponsiveSearchAd c) {
                return StringExtensions.toOptionalBulkString(((ResponsiveSearchAd)c.getAd()).getDomain());
            }
        }, new BiConsumer<String, BulkResponsiveSearchAd>(){

            @Override
            public void accept(String v, BulkResponsiveSearchAd c) {
                ((ResponsiveSearchAd)c.getAd()).setDomain(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveSearchAd, String>("Headline", new Function<BulkResponsiveSearchAd, String>(){

            @Override
            public String apply(BulkResponsiveSearchAd c) {
                return StringExtensions.toTextAssetLinksBulkString(((ResponsiveSearchAd)c.getAd()).getHeadlines());
            }
        }, new BiConsumer<String, BulkResponsiveSearchAd>(){

            @Override
            public void accept(String v, BulkResponsiveSearchAd c) {
                ((ResponsiveSearchAd)c.getAd()).setHeadlines(StringExtensions.parseTextAssetLinks(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveSearchAd, String>("Description", new Function<BulkResponsiveSearchAd, String>(){

            @Override
            public String apply(BulkResponsiveSearchAd c) {
                return StringExtensions.toTextAssetLinksBulkString(((ResponsiveSearchAd)c.getAd()).getDescriptions());
            }
        }, new BiConsumer<String, BulkResponsiveSearchAd>(){

            @Override
            public void accept(String v, BulkResponsiveSearchAd c) {
                ((ResponsiveSearchAd)c.getAd()).setDescriptions(StringExtensions.parseTextAssetLinks(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

