/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.Status;
import com.microsoft.bingads.v12.campaignmanagement.SharedEntityAssociation;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignNegativeKeywordList
extends SingleRecordBulkEntity {
    private SharedEntityAssociation sharedEntityAssociation;
    private Status status;
    private static final List<BulkMapping<BulkCampaignNegativeKeywordList>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setSharedEntityAssociation(new SharedEntityAssociation());
        this.getSharedEntityAssociation().setEntityType("Campaign");
        this.getSharedEntityAssociation().setSharedEntityType("NegativeKeywordList");
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public SharedEntityAssociation getSharedEntityAssociation() {
        return this.sharedEntityAssociation;
    }

    public void setSharedEntityAssociation(SharedEntityAssociation association) {
        this.sharedEntityAssociation = association;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignNegativeKeywordList, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignNegativeKeywordList, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignNegativeKeywordList, String>("Status", new Function<BulkCampaignNegativeKeywordList, String>(){

            @Override
            public String apply(BulkCampaignNegativeKeywordList c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeKeywordList>(){

            @Override
            public void accept(String v, BulkCampaignNegativeKeywordList c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeKeywordList, Long>("Id", new Function<BulkCampaignNegativeKeywordList, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeKeywordList c) {
                return c.getSharedEntityAssociation().getSharedEntityId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeKeywordList>(){

            @Override
            public void accept(String v, BulkCampaignNegativeKeywordList c) {
                c.getSharedEntityAssociation().setSharedEntityId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeKeywordList, Long>("Parent Id", new Function<BulkCampaignNegativeKeywordList, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeKeywordList c) {
                return c.getSharedEntityAssociation().getEntityId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeKeywordList>(){

            @Override
            public void accept(String v, BulkCampaignNegativeKeywordList c) {
                c.getSharedEntityAssociation().setEntityId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

