/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.internal.reporting;

import com.microsoft.bingads.v12.internal.reporting.ReportHeader;
import com.microsoft.bingads.v12.reporting.InvalidColumnException;
import com.microsoft.bingads.v12.reporting.Report;
import com.microsoft.bingads.v12.reporting.ReportRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XmlReport
extends Report {
    private XMLEventReader xmlEventReader;
    private ReportRecord nextRecord;

    public XmlReport(File xmlFile) throws XMLStreamException, FileNotFoundException {
        this(new FileInputStream(xmlFile));
    }

    public XmlReport(String xmlFilePath) throws XMLStreamException, FileNotFoundException {
        this(new FileInputStream(xmlFilePath));
    }

    public XmlReport(FileInputStream xmlFileInputStream) throws XMLStreamException {
        this.reportHeader = new ReportHeader();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlEventReader = xmlInputFactory.createXMLEventReader(xmlFileInputStream);
        this.parseMeta();
        this.parseColumnNames();
        try {
            this.moveToNextRecord();
        }
        catch (XMLStreamException e) {
            this.close();
        }
    }

    @Override
    public Iterable<ReportRecord> getReportRecords() {
        return new Iterable<ReportRecord>(){

            @Override
            public Iterator<ReportRecord> iterator() {
                return new Iterator<ReportRecord>(){

                    @Override
                    public boolean hasNext() {
                        return XmlReport.this.nextRecord != null;
                    }

                    @Override
                    public ReportRecord next() {
                        ReportRecord ret = XmlReport.this.nextRecord;
                        try {
                            XmlReport.this.nextRecord = null;
                            XmlReport.this.moveToNextRecord();
                        }
                        catch (XMLStreamException e) {
                            XmlReport.this.close();
                        }
                        return ret;
                    }
                };
            }
        };
    }

    @Override
    public void close() {
        try {
            if (this.xmlEventReader != null) {
                this.xmlEventReader.close();
                this.xmlEventReader = null;
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private void moveToNextRecord() throws XMLStreamException {
        final HashMap<String, String> keyValueMap = new HashMap<String, String>();
        boolean newRecord = false;
        while (this.xmlEventReader != null && this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextTag();
            if (xmlEvent.isStartElement()) {
                Attribute valueAttr;
                StartElement startElement = xmlEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals("Row")) {
                    newRecord = true;
                    continue;
                }
                if (!newRecord || (valueAttr = startElement.getAttributeByName(new QName("value"))) == null) continue;
                keyValueMap.put(startElement.getName().getLocalPart(), valueAttr.getValue());
                continue;
            }
            if (!xmlEvent.isEndElement()) continue;
            EndElement endElement = xmlEvent.asEndElement();
            if (endElement.getName().getLocalPart().equals("Row")) {
                if (keyValueMap.size() <= 0) break;
                this.nextRecord = new ReportRecord(){

                    @Override
                    public Double getDoubleValue(String header) throws InvalidColumnException, NumberFormatException {
                        if (!keyValueMap.containsKey(header)) {
                            throw new InvalidColumnException(header);
                        }
                        String value = (String)keyValueMap.get(header);
                        if (value == null) {
                            return null;
                        }
                        if ((value = value.trim()).endsWith("%")) {
                            value = value.replace("%", "");
                            Double result = Double.parseDouble(value) / 100.0;
                            return result;
                        }
                        return Double.parseDouble(value);
                    }

                    @Override
                    public Long getLongValue(String header) throws InvalidColumnException, NumberFormatException {
                        if (!keyValueMap.containsKey(header)) {
                            throw new InvalidColumnException(header);
                        }
                        String value = (String)keyValueMap.get(header);
                        if (value == null) {
                            return null;
                        }
                        value = value.trim();
                        return Long.parseLong(value);
                    }

                    @Override
                    public Integer getIntegerValue(String header) throws InvalidColumnException, NumberFormatException {
                        if (!keyValueMap.containsKey(header)) {
                            throw new InvalidColumnException(header);
                        }
                        String value = (String)keyValueMap.get(header);
                        if (value == null) {
                            return null;
                        }
                        value = value.trim();
                        return Integer.parseInt(value);
                    }

                    @Override
                    public String getStringValue(String header) throws InvalidColumnException {
                        if (!keyValueMap.containsKey(header)) {
                            throw new InvalidColumnException(header);
                        }
                        return (String)keyValueMap.get(header);
                    }
                };
                break;
            }
            if (!endElement.getName().getLocalPart().equalsIgnoreCase("Table")) continue;
            this.close();
            break;
        }
    }

    private void setReportColumnsIfExcludeColumnName(Map<String, String> keyValueMap) {
        if (this.reportHeader.getReportColumns() == null) {
            this.reportHeader.setReportColumns(keyValueMap.keySet().toArray(new String[0]));
        }
    }

    private void parseMeta() throws XMLStreamException {
        while (this.xmlEventReader != null && this.xmlEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xmlEvent = this.xmlEventReader.nextTag();
            if (!xmlEvent.isStartElement() || !(startElement = xmlEvent.asStartElement()).getName().getLocalPart().equals("Report")) continue;
            this.parseReportName(startElement);
            this.parseReportTime(startElement);
            this.parseReportAggregation(startElement);
            this.parseReportLastCompletedAvailableDate(startElement);
            this.parseReportTimeZone(startElement);
            this.parsePotentialIncompleteData(startElement);
            this.parseReportRecordCount(startElement);
            break;
        }
    }

    private void parseReportRecordCount(StartElement startElement) {
        Attribute nameAttr = startElement.getAttributeByName(new QName("Rows"));
        if (nameAttr != null) {
            this.reportHeader.setReportRecordCount(nameAttr.getValue());
        }
    }

    private void parsePotentialIncompleteData(StartElement startElement) {
        Attribute nameAttr = startElement.getAttributeByName(new QName("PotentialIncompleteData"));
        if (nameAttr != null) {
            this.reportHeader.setPotentialIncompleteData(nameAttr.getValue());
        }
    }

    private void parseReportLastCompletedAvailableDate(StartElement startElement) {
        Attribute nameAttrDay = startElement.getAttributeByName(new QName("LastCompletedAvailableDay"));
        if (nameAttrDay != null) {
            this.reportHeader.setLastCompletedAvailableDate(nameAttrDay.getValue());
        }
    }

    private void parseReportAggregation(StartElement startElement) {
        Attribute nameAttr = startElement.getAttributeByName(new QName("ReportAggregation"));
        if (nameAttr != null) {
            this.reportHeader.setReportAggregation(nameAttr.getValue());
        }
    }

    private void parseReportTimeZone(StartElement startElement) {
        Attribute nameAttr = startElement.getAttributeByName(new QName("TimeZone"));
        if (nameAttr != null) {
            this.reportHeader.setReportTimeZone(nameAttr.getValue());
        }
    }

    private void parseReportTime(StartElement startElement) {
        Attribute nameAttr = startElement.getAttributeByName(new QName("ReportTime"));
        if (nameAttr != null) {
            this.reportHeader.setReportTime(nameAttr.getValue());
        }
    }

    private void parseReportName(StartElement startElement) {
        Attribute nameAttr = startElement.getAttributeByName(new QName("ReportName"));
        if (nameAttr != null) {
            this.reportHeader.setReportName(nameAttr.getValue());
        }
    }

    private void parseColumnNames() throws XMLStreamException {
        LinkedList<String> columnList = new LinkedList<String>();
        while (this.xmlEventReader != null && this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextTag();
            if (!xmlEvent.isStartElement()) continue;
            StartElement startElement = xmlEvent.asStartElement();
            if (startElement.getName().getLocalPart().equals("Column")) {
                StartElement columnElement = xmlEvent.asStartElement();
                Attribute nameAttr = columnElement.getAttributeByName(new QName("name"));
                columnList.add(nameAttr.getValue());
                continue;
            }
            if (!startElement.getName().getLocalPart().equals("Table")) continue;
            if (columnList.size() <= 0) break;
            String[] columns = new String[columnList.size()];
            columnList.toArray(columns);
            this.reportHeader.setReportColumns(columns);
            break;
        }
    }
}

