/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.BulkAd;
import com.microsoft.bingads.v12.campaignmanagement.AdType;
import com.microsoft.bingads.v12.campaignmanagement.CallToAction;
import com.microsoft.bingads.v12.campaignmanagement.ResponsiveAd;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkResponsiveAd
extends BulkAd<ResponsiveAd> {
    private static final List<BulkMapping<BulkResponsiveAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getResponsiveAd(), ((ResponsiveAd)this.getAd()).getClass().getName());
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new ResponsiveAd());
        ((ResponsiveAd)this.getAd()).setType(AdType.RESPONSIVE_AD);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public ResponsiveAd getResponsiveAd() {
        return (ResponsiveAd)this.ad;
    }

    public void setResponsiveAd(ResponsiveAd ad) {
        this.setAd(ad);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkResponsiveAd, Object>> m = new ArrayList<SimpleBulkMapping<BulkResponsiveAd, Object>>();
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Business Name", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getBusinessName();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setBusinessName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Call To Action", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getCallToAction() != null ? ((ResponsiveAd)c.getAd()).getCallToAction().value() : null;
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setCallToAction(StringExtensions.parseOptional(v, new Function<String, CallToAction>(){

                    @Override
                    public CallToAction apply(String value) {
                        return CallToAction.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Headline", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getHeadline();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setHeadline(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Long Headline", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getLongHeadline();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setLongHeadline(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, Long>("Landscape Image Media Id", new Function<BulkResponsiveAd, Long>(){

            @Override
            public Long apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getLandscapeImageMediaId();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setLandscapeImageMediaId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, Long>("Landscape Logo Media Id", new Function<BulkResponsiveAd, Long>(){

            @Override
            public Long apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getLandscapeLogoMediaId();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setLandscapeLogoMediaId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, Long>("Square Image Media Id", new Function<BulkResponsiveAd, Long>(){

            @Override
            public Long apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getSquareImageMediaId();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setSquareImageMediaId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, Long>("Square Logo Media Id", new Function<BulkResponsiveAd, Long>(){

            @Override
            public Long apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getSquareLogoMediaId();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setSquareLogoMediaId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkResponsiveAd, String>("Text", new Function<BulkResponsiveAd, String>(){

            @Override
            public String apply(BulkResponsiveAd c) {
                return ((ResponsiveAd)c.getAd()).getText();
            }
        }, new BiConsumer<String, BulkResponsiveAd>(){

            @Override
            public void accept(String v, BulkResponsiveAd c) {
                ((ResponsiveAd)c.getAd()).setText(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

