/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v12.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.campaignmanagement.ProfileCriterion;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkCampaignProfileCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private String profileName;
    private static final List<BulkMapping<BulkCampaignProfileCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        ProfileCriterion criterion = new ProfileCriterion();
        this.setProfileType(criterion);
        campaignCriterion.setCriterion(criterion);
        campaignCriterion.getCriterion().setType(ProfileCriterion.class.getSimpleName());
        campaignCriterion.setCriterionBid(bidMultiplier);
        campaignCriterion.setType(BiddableCampaignCriterion.class.getSimpleName());
        this.setBiddableCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public abstract void setProfileType(ProfileCriterion var1);

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion biddableCampaignCriterion) {
        this.biddableCampaignCriterion = biddableCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignProfileCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignProfileCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignProfileCriterion, String>("Status", new Function<BulkCampaignProfileCriterion, String>(){

            @Override
            public String apply(BulkCampaignProfileCriterion c) {
                CampaignCriterionStatus status = c.getBiddableCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignProfileCriterion>(){

            @Override
            public void accept(String v, BulkCampaignProfileCriterion c) {
                c.getBiddableCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProfileCriterion, Long>("Id", new Function<BulkCampaignProfileCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignProfileCriterion c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignProfileCriterion>(){

            @Override
            public void accept(String v, BulkCampaignProfileCriterion c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProfileCriterion, Long>("Parent Id", new Function<BulkCampaignProfileCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignProfileCriterion c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignProfileCriterion>(){

            @Override
            public void accept(String v, BulkCampaignProfileCriterion c) {
                c.getBiddableCampaignCriterion().setCampaignId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProfileCriterion, String>("Campaign", new Function<BulkCampaignProfileCriterion, String>(){

            @Override
            public String apply(BulkCampaignProfileCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignProfileCriterion>(){

            @Override
            public void accept(String v, BulkCampaignProfileCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProfileCriterion, String>("Bid Adjustment", new Function<BulkCampaignProfileCriterion, String>(){

            @Override
            public String apply(BulkCampaignProfileCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getBiddableCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignProfileCriterion>(){

            @Override
            public void accept(String v, BulkCampaignProfileCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getBiddableCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProfileCriterion, String>("Profile", new Function<BulkCampaignProfileCriterion, String>(){

            @Override
            public String apply(BulkCampaignProfileCriterion c) {
                return c.getProfileName();
            }
        }, new BiConsumer<String, BulkCampaignProfileCriterion>(){

            @Override
            public void accept(String v, BulkCampaignProfileCriterion c) {
                c.setProfileName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProfileCriterion, Long>("Profile Id", new Function<BulkCampaignProfileCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignProfileCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof ProfileCriterion) {
                    return ((ProfileCriterion)c.getBiddableCampaignCriterion().getCriterion()).getProfileId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignProfileCriterion>(){

            @Override
            public void accept(String v, BulkCampaignProfileCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof ProfileCriterion) {
                    ((ProfileCriterion)c.getBiddableCampaignCriterion().getCriterion()).setProfileId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                        @Override
                        public Long apply(String s) {
                            return Long.parseLong(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

