/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.Supplier;
import com.microsoft.bingads.v11.bulk.entities.BulkAccount;
import com.microsoft.bingads.v11.bulk.entities.BulkAccountAppAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAccountCalloutAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAccountImageAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAccountLocationAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAccountPriceAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAccountReviewAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAccountSitelink2AdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAccountStructuredSnippetAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroup;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupAgeCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupAppAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupCalloutAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupCustomAudienceAssociation;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupDayTimeCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupDeviceCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupDynamicSearchAdTarget;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupGenderCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupImageAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupInMarketAudienceAssociation;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupLabel;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupLocationCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupLocationIntentCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeCustomAudienceAssociation;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeDynamicSearchAdTarget;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeInMarketAudienceAssociation;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeKeyword;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeLocationCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeRemarketingListAssociation;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupNegativeSite;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupPriceAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupProductPartition;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupRadiusCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupRemarketingListAssociation;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupReviewAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupSiteLinkAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupSitelink2AdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAdGroupStructuredSnippetAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAppAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkAppInstallAd;
import com.microsoft.bingads.v11.bulk.entities.BulkAppInstallAdLabel;
import com.microsoft.bingads.v11.bulk.entities.BulkBudget;
import com.microsoft.bingads.v11.bulk.entities.BulkCallAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCalloutAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaign;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignAgeCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignAppAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignCallAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignCalloutAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignDayTimeCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignDeviceCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignGenderCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignImageAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignLabel;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignLocationAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignLocationCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignLocationIntentCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignNegativeDynamicSearchAdTarget;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignNegativeKeyword;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignNegativeKeywordList;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignNegativeLocationCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignNegativeSite;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignPriceAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignProductScope;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignRadiusCriterion;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignReviewAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignSiteLinkAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignSitelink2AdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCampaignStructuredSnippetAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkCustomAudience;
import com.microsoft.bingads.v11.bulk.entities.BulkDynamicSearchAd;
import com.microsoft.bingads.v11.bulk.entities.BulkDynamicSearchAdLabel;
import com.microsoft.bingads.v11.bulk.entities.BulkError;
import com.microsoft.bingads.v11.bulk.entities.BulkExpandedTextAd;
import com.microsoft.bingads.v11.bulk.entities.BulkExpandedTextAdLabel;
import com.microsoft.bingads.v11.bulk.entities.BulkImageAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkInMarketAudience;
import com.microsoft.bingads.v11.bulk.entities.BulkKeyword;
import com.microsoft.bingads.v11.bulk.entities.BulkKeywordBestPositionBid;
import com.microsoft.bingads.v11.bulk.entities.BulkKeywordFirstPageBid;
import com.microsoft.bingads.v11.bulk.entities.BulkKeywordLabel;
import com.microsoft.bingads.v11.bulk.entities.BulkKeywordMainLineBid;
import com.microsoft.bingads.v11.bulk.entities.BulkLabel;
import com.microsoft.bingads.v11.bulk.entities.BulkLocationAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkNegativeKeywordList;
import com.microsoft.bingads.v11.bulk.entities.BulkOfflineConversion;
import com.microsoft.bingads.v11.bulk.entities.BulkPriceAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkProductAd;
import com.microsoft.bingads.v11.bulk.entities.BulkProductAdLabel;
import com.microsoft.bingads.v11.bulk.entities.BulkRemarketingList;
import com.microsoft.bingads.v11.bulk.entities.BulkReviewAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkSharedNegativeKeyword;
import com.microsoft.bingads.v11.bulk.entities.BulkSiteLink;
import com.microsoft.bingads.v11.bulk.entities.BulkSitelink2AdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkStructuredSnippetAdExtension;
import com.microsoft.bingads.v11.bulk.entities.BulkTextAd;
import com.microsoft.bingads.v11.bulk.entities.BulkTextAdLabel;
import com.microsoft.bingads.v11.bulk.entities.EntityInfo;
import com.microsoft.bingads.v11.bulk.entities.UnknownBulkEntity;
import com.microsoft.bingads.v11.internal.bulk.BulkObject;
import com.microsoft.bingads.v11.internal.bulk.BulkObjectFactory;
import com.microsoft.bingads.v11.internal.bulk.Creator;
import com.microsoft.bingads.v11.internal.bulk.FormatVersion;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.entities.BulkAdGroupNegativeSitesIdentifier;
import com.microsoft.bingads.v11.internal.bulk.entities.BulkCampaignNegativeSitesIdentifier;
import com.microsoft.bingads.v11.internal.bulk.entities.BulkEntityIdentifier;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.v11.internal.bulk.entities.SiteLinkAdExtensionIdentifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StaticBulkObjectFactory
implements BulkObjectFactory {
    private static final Map<Class<? extends BulkObject>, String> TYPE_REVERSE_MAP;
    private static final Map<String, EntityInfo> INDIVIDUAL_ENTITY_MAP;
    private static final Map<String, Supplier<BulkObject>> ADDITIONAL_OBJECT_MAP;

    @Override
    public BulkObject createBulkObject(RowValues values) {
        String type = values.get("Type");
        if (type.endsWith("Error")) {
            return new BulkError();
        }
        if (ADDITIONAL_OBJECT_MAP.containsKey(type)) {
            return ADDITIONAL_OBJECT_MAP.get(type).get();
        }
        if (!INDIVIDUAL_ENTITY_MAP.containsKey(type)) {
            return new UnknownBulkEntity();
        }
        EntityInfo info = INDIVIDUAL_ENTITY_MAP.get(type);
        if ("Deleted".equals(values.get("Status")) && info.getDeleteAllColumnName() != null && !info.getDeleteAllColumnName().isEmpty() && (values.get(info.getDeleteAllColumnName()) == null || values.get(info.getDeleteAllColumnName()).isEmpty())) {
            return info.getIdentifierCreator().create();
        }
        return info.getCreator().create();
    }

    @Override
    public String getBulkRowType(BulkObject bulkObject) {
        if (bulkObject instanceof BulkError) {
            BulkError error = (BulkError)bulkObject;
            return this.getBulkRowType(error.getEntity()) + " Error";
        }
        return TYPE_REVERSE_MAP.get(bulkObject.getClass());
    }

    static {
        HashMap<String, EntityInfo> m = new HashMap<String, EntityInfo>();
        m.put("Account", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccount();
            }
        }));
        m.put("Campaign", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaign();
            }
        }));
        m.put("Ad Group", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroup();
            }
        }));
        m.put("Product Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkProductAd();
            }
        }));
        m.put("Text Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkTextAd();
            }
        }));
        m.put("App Install Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAppInstallAd();
            }
        }));
        m.put("Expanded Text Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkExpandedTextAd();
            }
        }));
        m.put("Dynamic Search Ad", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkDynamicSearchAd();
            }
        }));
        m.put("Campaign Negative Dynamic Search Ad Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeDynamicSearchAdTarget();
            }
        }));
        m.put("Ad Group Negative Dynamic Search Ad Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeDynamicSearchAdTarget();
            }
        }));
        m.put("Ad Group Dynamic Search Ad Target", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupDynamicSearchAdTarget();
            }
        }));
        m.put("Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkKeyword();
            }
        }));
        m.put("Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkSiteLink();
            }
        }, "Sitelink Extension Order", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new SiteLinkAdExtensionIdentifier();
            }
        }));
        m.put("Campaign Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignSiteLinkAdExtension();
            }
        }));
        m.put("AdGroup Sitelink Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupSiteLinkAdExtension();
            }
        }));
        m.put("Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkImageAdExtension();
            }
        }));
        m.put("Account Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountImageAdExtension();
            }
        }));
        m.put("Campaign Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignImageAdExtension();
            }
        }));
        m.put("Ad Group Image Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupImageAdExtension();
            }
        }));
        m.put("Location Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkLocationAdExtension();
            }
        }));
        m.put("Account Location Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountLocationAdExtension();
            }
        }));
        m.put("Campaign Location Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLocationAdExtension();
            }
        }));
        m.put("Call Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCallAdExtension();
            }
        }));
        m.put("Campaign Call Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignCallAdExtension();
            }
        }));
        m.put("App Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAppAdExtension();
            }
        }));
        m.put("Account App Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountAppAdExtension();
            }
        }));
        m.put("Campaign App Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignAppAdExtension();
            }
        }));
        m.put("Ad Group App Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupAppAdExtension();
            }
        }));
        m.put("Callout Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCalloutAdExtension();
            }
        }));
        m.put("Account Callout Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountCalloutAdExtension();
            }
        }));
        m.put("Campaign Callout Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignCalloutAdExtension();
            }
        }));
        m.put("Ad Group Callout Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupCalloutAdExtension();
            }
        }));
        m.put("Price Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkPriceAdExtension();
            }
        }));
        m.put("Account Price Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountPriceAdExtension();
            }
        }));
        m.put("Campaign Price Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignPriceAdExtension();
            }
        }));
        m.put("Ad Group Price Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupPriceAdExtension();
            }
        }));
        m.put("Review Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkReviewAdExtension();
            }
        }));
        m.put("Account Review Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountReviewAdExtension();
            }
        }));
        m.put("Campaign Review Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignReviewAdExtension();
            }
        }));
        m.put("Ad Group Review Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupReviewAdExtension();
            }
        }));
        m.put("Sitelink2 Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkSitelink2AdExtension();
            }
        }));
        m.put("Account Sitelink2 Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountSitelink2AdExtension();
            }
        }));
        m.put("Campaign Sitelink2 Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignSitelink2AdExtension();
            }
        }));
        m.put("Ad Group Sitelink2 Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupSitelink2AdExtension();
            }
        }));
        m.put("Structured Snippet Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkStructuredSnippetAdExtension();
            }
        }));
        m.put("Account Structured Snippet Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAccountStructuredSnippetAdExtension();
            }
        }));
        m.put("Campaign Structured Snippet Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignStructuredSnippetAdExtension();
            }
        }));
        m.put("Ad Group Structured Snippet Ad Extension", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupStructuredSnippetAdExtension();
            }
        }));
        m.put("Campaign Negative Site", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeSite();
            }
        }, "Website", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkCampaignNegativeSitesIdentifier();
            }
        }));
        m.put("Ad Group Negative Site", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeSite();
            }
        }, "Website", new Creator<BulkEntityIdentifier>(){

            @Override
            public BulkEntityIdentifier create() {
                return new BulkAdGroupNegativeSitesIdentifier();
            }
        }));
        m.put("Campaign Product Scope", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignProductScope();
            }
        }));
        m.put("Ad Group Product Partition", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupProductPartition();
            }
        }));
        m.put("Campaign Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeKeyword();
            }
        }));
        m.put("Ad Group Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeKeyword();
            }
        }));
        m.put("Negative Keyword List", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkNegativeKeywordList();
            }
        }));
        m.put("Shared Negative Keyword", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkSharedNegativeKeyword();
            }
        }));
        m.put("Campaign Negative Keyword List Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeKeywordList();
            }
        }));
        m.put("Remarketing List", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkRemarketingList();
            }
        }));
        m.put("Ad Group Remarketing List Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupRemarketingListAssociation();
            }
        }));
        m.put("Ad Group Negative Remarketing List Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeRemarketingListAssociation();
            }
        }));
        m.put("Custom Audience", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCustomAudience();
            }
        }));
        m.put("Ad Group Custom Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupCustomAudienceAssociation();
            }
        }));
        m.put("Ad Group Negative Custom Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeCustomAudienceAssociation();
            }
        }));
        m.put("In Market Audience", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkInMarketAudience();
            }
        }));
        m.put("Ad Group In Market Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupInMarketAudienceAssociation();
            }
        }));
        m.put("Ad Group Negative In Market Audience Association", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeInMarketAudienceAssociation();
            }
        }));
        m.put("Budget", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkBudget();
            }
        }));
        m.put("Ad Group Age Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupAgeCriterion();
            }
        }));
        m.put("Ad Group DeviceOS Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupDeviceCriterion();
            }
        }));
        m.put("Ad Group DayTime Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupDayTimeCriterion();
            }
        }));
        m.put("Ad Group Radius Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupRadiusCriterion();
            }
        }));
        m.put("Ad Group Gender Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupGenderCriterion();
            }
        }));
        m.put("Ad Group Location Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupLocationCriterion();
            }
        }));
        m.put("Ad Group Location Intent Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupLocationIntentCriterion();
            }
        }));
        m.put("Ad Group Negative Location Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupNegativeLocationCriterion();
            }
        }));
        m.put("Campaign Age Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignAgeCriterion();
            }
        }));
        m.put("Campaign DeviceOS Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignDeviceCriterion();
            }
        }));
        m.put("Campaign DayTime Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignDayTimeCriterion();
            }
        }));
        m.put("Campaign Radius Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignRadiusCriterion();
            }
        }));
        m.put("Campaign Gender Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignGenderCriterion();
            }
        }));
        m.put("Campaign Location Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLocationCriterion();
            }
        }));
        m.put("Campaign Location Intent Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLocationIntentCriterion();
            }
        }));
        m.put("Campaign Negative Location Criterion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignNegativeLocationCriterion();
            }
        }));
        m.put("Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkLabel();
            }
        }));
        m.put("Campaign Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkCampaignLabel();
            }
        }));
        m.put("Ad Group Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAdGroupLabel();
            }
        }));
        m.put("Keyword Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkKeywordLabel();
            }
        }));
        m.put("App Install Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkAppInstallAdLabel();
            }
        }));
        m.put("Dynamic Search Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkDynamicSearchAdLabel();
            }
        }));
        m.put("Expanded Text Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkExpandedTextAdLabel();
            }
        }));
        m.put("Product Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkProductAdLabel();
            }
        }));
        m.put("Text Ad Label", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkTextAdLabel();
            }
        }));
        m.put("Offline Conversion", new EntityInfo(new Creator<SingleRecordBulkEntity>(){

            @Override
            public SingleRecordBulkEntity create() {
                return new BulkOfflineConversion();
            }
        }));
        INDIVIDUAL_ENTITY_MAP = Collections.unmodifiableMap(m);
        HashMap<String, Supplier<BulkObject>> addl = new HashMap<String, Supplier<BulkObject>>();
        addl.put("Keyword Best Position Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordBestPositionBid();
            }
        });
        addl.put("Keyword Main Line Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordMainLineBid();
            }
        });
        addl.put("Keyword First Page Bid", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new BulkKeywordFirstPageBid();
            }
        });
        addl.put("Format Version", new Supplier<BulkObject>(){

            @Override
            public BulkObject get() {
                return new FormatVersion();
            }
        });
        ADDITIONAL_OBJECT_MAP = Collections.unmodifiableMap(addl);
        HashMap c = new HashMap();
        for (Map.Entry<String, EntityInfo> entry : INDIVIDUAL_ENTITY_MAP.entrySet()) {
            c.put(entry.getValue().getCreator().create().getClass(), entry.getKey());
            if (entry.getValue().getIdentifierCreator() == null) continue;
            BulkEntityIdentifier identifier = entry.getValue().getIdentifierCreator().create();
            c.put(identifier.getClass(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : ADDITIONAL_OBJECT_MAP.entrySet()) {
            c.put(((BulkObject)((Supplier)entry.getValue()).get()).getClass(), entry.getKey());
        }
        TYPE_REVERSE_MAP = Collections.unmodifiableMap(c);
    }
}

