/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.Status;
import com.microsoft.bingads.v11.campaignmanagement.CustomAudience;
import com.microsoft.bingads.v11.campaignmanagement.EntityScope;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCustomAudience
extends SingleRecordBulkEntity {
    private CustomAudience customAudience;
    private Status status;
    private static final List<BulkMapping<BulkCustomAudience>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setCustomAudience(new CustomAudience());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCustomAudience(), "CustomAudience");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public CustomAudience getCustomAudience() {
        return this.customAudience;
    }

    public void setCustomAudience(CustomAudience customAudience) {
        this.customAudience = customAudience;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCustomAudience, Object>> m = new ArrayList<SimpleBulkMapping<BulkCustomAudience, Object>>();
        m.add(new SimpleBulkMapping<BulkCustomAudience, String>("Status", new Function<BulkCustomAudience, String>(){

            @Override
            public String apply(BulkCustomAudience c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCustomAudience>(){

            @Override
            public void accept(String v, BulkCustomAudience c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomAudience, Long>("Id", new Function<BulkCustomAudience, Long>(){

            @Override
            public Long apply(BulkCustomAudience c) {
                return c.getCustomAudience().getId();
            }
        }, new BiConsumer<String, BulkCustomAudience>(){

            @Override
            public void accept(String v, BulkCustomAudience c) {
                c.getCustomAudience().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomAudience, Long>("Parent Id", new Function<BulkCustomAudience, Long>(){

            @Override
            public Long apply(BulkCustomAudience c) {
                return c.getCustomAudience().getParentId();
            }
        }, new BiConsumer<String, BulkCustomAudience>(){

            @Override
            public void accept(String v, BulkCustomAudience c) {
                c.getCustomAudience().setParentId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomAudience, String>("Audience", new Function<BulkCustomAudience, String>(){

            @Override
            public String apply(BulkCustomAudience c) {
                return c.getCustomAudience().getName();
            }
        }, new BiConsumer<String, BulkCustomAudience>(){

            @Override
            public void accept(String v, BulkCustomAudience c) {
                c.getCustomAudience().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomAudience, Long>("Audience Search Size", new Function<BulkCustomAudience, Long>(){

            @Override
            public Long apply(BulkCustomAudience c) {
                return c.getCustomAudience().getSearchSize();
            }
        }, new BiConsumer<String, BulkCustomAudience>(){

            @Override
            public void accept(String v, BulkCustomAudience c) {
                c.getCustomAudience().setSearchSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomAudience, String>("Description", new Function<BulkCustomAudience, String>(){

            @Override
            public String apply(BulkCustomAudience c) {
                return c.getCustomAudience().getDescription();
            }
        }, new BiConsumer<String, BulkCustomAudience>(){

            @Override
            public void accept(String v, BulkCustomAudience c) {
                c.getCustomAudience().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomAudience, Integer>("Membership Duration", new Function<BulkCustomAudience, Integer>(){

            @Override
            public Integer apply(BulkCustomAudience c) {
                return c.getCustomAudience().getMembershipDuration();
            }
        }, new BiConsumer<String, BulkCustomAudience>(){

            @Override
            public void accept(String v, BulkCustomAudience c) {
                c.getCustomAudience().setMembershipDuration(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomAudience, String>("Scope", new Function<BulkCustomAudience, String>(){

            @Override
            public String apply(BulkCustomAudience c) {
                return c.getCustomAudience().getScope() != null ? c.getCustomAudience().getScope().value() : null;
            }
        }, new BiConsumer<String, BulkCustomAudience>(){

            @Override
            public void accept(String v, BulkCustomAudience c) {
                c.getCustomAudience().setScope(StringExtensions.parseOptional(v, new Function<String, EntityScope>(){

                    @Override
                    public EntityScope apply(String value) {
                        return EntityScope.fromValue(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

