/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.internal.bulk;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.v11.bulk.EntityReadException;
import com.microsoft.bingads.v11.bulk.EntityWriteException;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import java.util.List;

public class MappingHelpers {
    public static <T> void convertToEntity(RowValues values, List<BulkMapping<T>> mappings, T entity) {
        for (BulkMapping<T> mapping : mappings) {
            try {
                mapping.convertToEntity(values, entity);
            }
            catch (NumberFormatException ex) {
                throw MappingHelpers.createEntityReadException(values, mapping, ex, entity.getClass());
            }
            catch (UncheckedParseException ex) {
                throw MappingHelpers.createEntityReadException(values, mapping, ex, entity.getClass());
            }
            catch (NullPointerException ex) {
                throw MappingHelpers.createEntityReadException(values, mapping, ex, entity.getClass());
            }
            catch (IllegalArgumentException ex) {
                throw MappingHelpers.createEntityReadException(values, mapping, ex, entity.getClass());
            }
        }
    }

    public static <T> void convertToValues(T entity, RowValues values, List<BulkMapping<T>> mappings) {
        for (BulkMapping<T> mapping : mappings) {
            try {
                mapping.convertToCsv(entity, values);
            }
            catch (NullPointerException ex) {
                throw MappingHelpers.createEntityWriteException(mapping, ex, entity.getClass());
            }
            catch (IllegalArgumentException ex) {
                throw MappingHelpers.createEntityWriteException(mapping, ex, entity.getClass());
            }
        }
    }

    private static EntityReadException createEntityReadException(RowValues values, BulkMapping mapping, Throwable exception, Class classOfT) {
        String message;
        String entityType = classOfT.getSimpleName();
        if (mapping instanceof SimpleBulkMapping) {
            SimpleBulkMapping simpleMapping = (SimpleBulkMapping)mapping;
            message = String.format("Couldn't parse column %s of %s entity: %s", simpleMapping.getHeader(null), entityType, exception.getMessage());
        } else {
            message = String.format("Couldn't parse %s entity: %s", entityType, exception.getMessage());
        }
        message = message + ". See ColumnValues for detailed row information and cause for error details.";
        return new EntityReadException(message, values.toDebugString(), exception);
    }

    private static EntityWriteException createEntityWriteException(BulkMapping mapping, Throwable exception, Class classOfT) {
        String message;
        String entityType = classOfT.getSimpleName();
        if (mapping instanceof SimpleBulkMapping) {
            SimpleBulkMapping simpleMapping = (SimpleBulkMapping)mapping;
            message = String.format("Couldn't write column %s of %s entity: %s", simpleMapping.getHeader(null), entityType, exception.getMessage());
        } else {
            message = String.format("Couldn't write %s entity: %s", entityType, exception.getMessage());
        }
        message = message + ". See cause for error details.";
        return new EntityWriteException(message, exception);
    }
}

