/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class BulkAccount
extends SingleRecordBulkEntity {
    private long id;
    private long customerId;
    private Calendar syncTime;
    private static final List<BulkMapping<BulkAccount>> MAPPINGS;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(long customerId) {
        this.customerId = customerId;
    }

    public Calendar getSyncTime() {
        return this.syncTime;
    }

    public void setSyncTime(Calendar syncTime) {
        this.syncTime = syncTime;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAccount, Object>> m = new ArrayList<SimpleBulkMapping<BulkAccount, Object>>();
        m.add(new SimpleBulkMapping<BulkAccount, Long>("Id", new Function<BulkAccount, Long>(){

            @Override
            public Long apply(BulkAccount t) {
                return t.getId();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, Long>("Parent Id", new Function<BulkAccount, Long>(){

            @Override
            public Long apply(BulkAccount t) {
                return t.getCustomerId();
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setCustomerId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAccount, String>("Sync Time", new Function<BulkAccount, String>(){

            @Override
            public String apply(BulkAccount t) {
                if (t.getSyncTime() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getSyncTime().getTime());
            }
        }, new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setSyncTime(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

