/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.HeaderHandler;
import com.microsoft.bingads.internal.OAuthWithAuthorizationCode;
import com.microsoft.bingads.internal.ServiceFactory;
import com.microsoft.bingads.internal.ServiceFactoryFactory;
import com.microsoft.bingads.internal.ServiceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

public class ServiceClient<T> {
    private static Logger logger = Logger.getLogger(ServiceClient.class.getName());
    private final AuthorizationData authorizationData;
    private final Class<T> serviceInterface;
    private final Service service;
    private final ServiceFactory serviceFactory;
    private ApiEnvironment environment;

    public ApiEnvironment getEnvironment() {
        return this.environment;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public ServiceClient(AuthorizationData authorizationData, Class<T> serviceInterface) {
        this(authorizationData, null, serviceInterface);
    }

    public ServiceClient(AuthorizationData authorizationData, ApiEnvironment environment, Class<T> serviceInterface) {
        this.authorizationData = authorizationData;
        this.serviceInterface = serviceInterface;
        if (environment == null) {
            environment = this.getEnvironmentFromConfig();
        }
        if (environment == null) {
            environment = ApiEnvironment.PRODUCTION;
        }
        this.environment = environment;
        this.serviceFactory = ServiceFactoryFactory.createServiceFactory();
        this.service = this.serviceFactory.createService(serviceInterface, environment);
    }

    public T getService() {
        this.authorizationData.validate();
        WebService webServiceAnnotation = this.serviceInterface.getAnnotation(WebService.class);
        final String ns = webServiceAnnotation.targetNamespace();
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CustomerAccountId", Long.toString(this.authorizationData.getAccountId()));
        headers.put("CustomerId", Long.toString(this.authorizationData.getCustomerId()));
        headers.put("DeveloperToken", this.authorizationData.getDeveloperToken());
        this.refreshOAuthTokensIfNeeded();
        this.authorizationData.getAuthentication().addHeaders(new HeadersImpl(){

            @Override
            public void addHeader(String name, String value) {
                headers.put(name, value);
            }
        });
        this.service.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new HeaderHandler(ns, headers));
                return handlerList;
            }
        });
        T port = this.serviceFactory.createProxyFromService(this.service, this.environment, this.serviceInterface);
        return port;
    }

    private void refreshOAuthTokensIfNeeded() {
        if (this.authorizationData.getAuthentication() instanceof OAuthWithAuthorizationCode) {
            OAuthWithAuthorizationCode auth = (OAuthWithAuthorizationCode)this.authorizationData.getAuthentication();
            auth.refreshTokensIfNeeded(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiEnvironment getEnvironmentFromConfig() {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream(ServiceUtils.getPropertyFile());
            if (input == null) {
                ApiEnvironment apiEnvironment = null;
                return apiEnvironment;
            }
            Properties props = new Properties();
            props.load(input);
            String envString = props.getProperty("environment");
            if (envString == null) {
                ApiEnvironment apiEnvironment = null;
                return apiEnvironment;
            }
            ApiEnvironment apiEnvironment = ApiEnvironment.fromValue(envString);
            return apiEnvironment;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "Failed to read propertyFile: " + ServiceUtils.getPropertyFile(), ex);
            ApiEnvironment apiEnvironment = null;
            return apiEnvironment;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                throw new InternalException(ex);
            }
        }
    }
}

