/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.internal.bulk;

import com.microsoft.bingads.internal.functionalinterfaces.Predicate;
import com.microsoft.bingads.v10.bulk.DownloadFileType;
import com.microsoft.bingads.v10.internal.bulk.BulkObject;
import com.microsoft.bingads.v10.internal.bulk.BulkObjectReader;
import com.microsoft.bingads.v10.internal.bulk.BulkStreamReader;
import com.microsoft.bingads.v10.internal.bulk.FormatVersion;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkObjectReader;
import com.microsoft.bingads.v10.internal.bulk.TryResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class SimpleBulkStreamReader
implements BulkStreamReader {
    private BulkObjectReader objectReader;
    private BulkObject nextObject;
    private boolean passedFirstRow = false;

    public SimpleBulkStreamReader(File file, DownloadFileType fileFormat) throws FileNotFoundException, UnsupportedEncodingException {
        this(new SimpleBulkObjectReader(file, fileFormat == DownloadFileType.TSV ? (char)'\t' : ','));
    }

    public SimpleBulkStreamReader(InputStream inputStream, DownloadFileType fileFormat) throws FileNotFoundException, UnsupportedEncodingException {
        this(new SimpleBulkObjectReader(inputStream, fileFormat == DownloadFileType.TSV ? (char)'\t' : ','));
    }

    public SimpleBulkStreamReader(BulkObjectReader reader) {
        this.objectReader = reader;
    }

    @Override
    public BulkObject read() {
        TryResult<BulkObject> result = this.tryRead(BulkObject.class);
        if (result.isSuccessful()) {
            return result.getResult();
        }
        return null;
    }

    @Override
    public <T extends BulkObject> TryResult<T> tryRead(Class<T> klazz) {
        return this.tryRead(new Predicate<T>(){

            @Override
            public boolean test(T obj) {
                return true;
            }
        }, klazz);
    }

    @Override
    public <T extends BulkObject> TryResult<T> tryRead(Predicate<T> predicate, Class<T> klazz) {
        BulkObject peeked = this.peek();
        if (klazz.isInstance(peeked) && predicate.test(klazz.cast(peeked))) {
            this.nextObject = null;
            peeked.readRelatedDataFromStream(this);
            return new TryResult<T>(true, klazz.cast(peeked));
        }
        return new TryResult<Object>(false, null);
    }

    private BulkObject peek() {
        if (!this.passedFirstRow) {
            BulkObject firstRowObject = this.objectReader.readNextBulkObject();
            if (firstRowObject instanceof FormatVersion) {
                String version;
                FormatVersion formatVersion = (FormatVersion)firstRowObject;
                if (formatVersion != null && !(version = formatVersion.getValue()).equals("4") && !version.equals("4.0")) {
                    throw new UnsupportedOperationException("Format version is not supported: " + version);
                }
            } else {
                this.nextObject = firstRowObject;
            }
            this.passedFirstRow = true;
        }
        if (this.nextObject != null) {
            return this.nextObject;
        }
        this.nextObject = this.objectReader.readNextBulkObject();
        return this.nextObject;
    }

    @Override
    public void close() throws IOException {
        this.objectReader.close();
    }
}

