/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.PerformanceData;
import com.microsoft.bingads.v11.bulk.entities.QualityScoreData;
import com.microsoft.bingads.v11.campaignmanagement.AdDistribution;
import com.microsoft.bingads.v11.campaignmanagement.AdGroup;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupStatus;
import com.microsoft.bingads.v11.campaignmanagement.Network;
import com.microsoft.bingads.v11.campaignmanagement.PricingModel;
import com.microsoft.bingads.v11.campaignmanagement.RemarketingTargetingSetting;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroup
extends SingleRecordBulkEntity {
    private Long campaignId;
    private String campaignName;
    private AdGroup adGroup;
    private QualityScoreData qualityScoreData;
    private PerformanceData performanceData;
    private boolean isExpired;
    private static final List<BulkMapping<BulkAdGroup>> MAPPINGS;
    private static final BiConsumer<String, BulkAdGroup> orSearchAdDistribution;
    private static final BiConsumer<String, BulkAdGroup> orContentAdDistribution;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAdGroup(new AdGroup());
        this.getAdGroup().setAdDistribution(new ArrayList<AdDistribution>(2));
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.qualityScoreData = QualityScoreData.readFromRowValuesOrNull(values);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroup(), "AdGroup");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            QualityScoreData.writeToRowValuesIfNotNull(this.qualityScoreData, values);
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public Long getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public AdGroup getAdGroup() {
        return this.adGroup;
    }

    public void setAdGroup(AdGroup adGroup) {
        this.adGroup = adGroup;
    }

    public QualityScoreData getQualityScoreData() {
        return this.qualityScoreData;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    public boolean getIsExpired() {
        return this.isExpired;
    }

    private void setIsExpired(boolean isExpired) {
        this.isExpired = isExpired;
    }

    static {
        orSearchAdDistribution = new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                if ("On".equals(v)) {
                    c.getAdGroup().getAdDistribution().add(AdDistribution.SEARCH);
                }
            }
        };
        orContentAdDistribution = new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                if ("On".equals(v)) {
                    c.getAdGroup().getAdDistribution().add(AdDistribution.CONTENT);
                }
            }
        };
        ArrayList<SimpleBulkMapping<BulkAdGroup, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroup, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroup, Long>("Id", new Function<BulkAdGroup, Long>(){

            @Override
            public Long apply(BulkAdGroup c) {
                return c.getAdGroup().getId();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Status", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                if (c.getIsExpired()) {
                    return "Expired";
                }
                return c.getAdGroup().getStatus() != null ? c.getAdGroup().getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                if (v.equals("Expired")) {
                    c.getAdGroup().setStatus(AdGroupStatus.EXPIRED);
                    c.setIsExpired(true);
                } else {
                    c.getAdGroup().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupStatus>(){

                        @Override
                        public AdGroupStatus apply(String value) {
                            return AdGroupStatus.fromValue(value);
                        }
                    }));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, Long>("Parent Id", new Function<BulkAdGroup, Long>(){

            @Override
            public Long apply(BulkAdGroup c) {
                return c.getCampaignId();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.setCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Campaign", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Ad Group", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getAdGroup().getName();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Start Date", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toDateBulkString(c.getAdGroup().getStartDate());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                try {
                    c.getAdGroup().setStartDate(StringExtensions.parseDate(v));
                }
                catch (ParseException ex) {
                    throw new UncheckedParseException(ex);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("End Date", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toDateBulkString(c.getAdGroup().getEndDate());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                try {
                    c.getAdGroup().setEndDate(StringExtensions.parseDate(v));
                }
                catch (ParseException ex) {
                    throw new UncheckedParseException(ex);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Network Distribution", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getAdGroup().getNetwork() != null ? c.getAdGroup().getNetwork().value() : null;
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setNetwork(StringExtensions.parseOptional(v, new Function<String, Network>(){

                    @Override
                    public Network apply(String value) {
                        return Network.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Pricing Model", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getAdGroup().getPricingModel() != null ? c.getAdGroup().getPricingModel().value() : null;
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setPricingModel(StringExtensions.parseOptionalUpperCase(v, new Function<String, PricingModel>(){

                    @Override
                    public PricingModel apply(String value) {
                        return PricingModel.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Ad Rotation", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toAdRotationBulkString(c.getAdGroup().getAdRotation());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setAdRotation(StringExtensions.parseAdRotation(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Search Network", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.isOnOrOff(c.getAdGroup().getAdDistribution(), AdDistribution.SEARCH);
            }
        }, orSearchAdDistribution));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Content Network", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.isOnOrOff(c.getAdGroup().getAdDistribution(), AdDistribution.CONTENT);
            }
        }, orContentAdDistribution));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Search Bid", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toAdGroupBidBulkString(c.getAdGroup().getSearchBid());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setSearchBid(StringExtensions.parseAdGroupBid(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Content Bid", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toAdGroupBidBulkString(c.getAdGroup().getContentMatchBid());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setContentMatchBid(StringExtensions.parseAdGroupBid(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Language", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toOptionalBulkString(c.getAdGroup().getLanguage());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setLanguage(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, Integer>("Bid Adjustment", new Function<BulkAdGroup, Integer>(){

            @Override
            public Integer apply(BulkAdGroup c) {
                return c.getAdGroup().getNativeBidAdjustment();
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setNativeBidAdjustment(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Tracking Template", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toOptionalBulkString(c.getAdGroup().getTrackingUrlTemplate());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Custom Parameter", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return StringExtensions.toCustomParaBulkString(c.getAdGroup().getUrlCustomParameters());
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                try {
                    c.getAdGroup().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Bid Strategy Type", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                try {
                    return StringExtensions.toBiddingSchemeBulkString(c.getAdGroup().getBiddingScheme());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                try {
                    c.getAdGroup().setBiddingScheme(StringExtensions.parseBiddingScheme(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroup, String>("Remarketing Targeting Setting", new Function<BulkAdGroup, String>(){

            @Override
            public String apply(BulkAdGroup c) {
                return c.getAdGroup().getRemarketingTargetingSetting() != null ? c.getAdGroup().getRemarketingTargetingSetting().value() : null;
            }
        }, new BiConsumer<String, BulkAdGroup>(){

            @Override
            public void accept(String v, BulkAdGroup c) {
                c.getAdGroup().setRemarketingTargetingSetting(StringExtensions.parseOptional(v, new Function<String, RemarketingTargetingSetting>(){

                    @Override
                    public RemarketingTargetingSetting apply(String value) {
                        return RemarketingTargetingSetting.fromValue(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

