/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.AgeCriterion;
import com.microsoft.bingads.v11.campaignmanagement.AgeRange;
import com.microsoft.bingads.v11.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v11.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupAgeCriterion
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion adGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupAgeCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        AgeCriterion ageCriterion = new AgeCriterion();
        adGroupCriterion.setCriterion(ageCriterion);
        adGroupCriterion.getCriterion().setType(AgeCriterion.class.getSimpleName());
        adGroupCriterion.setCriterionBid(bidMultiplier);
        adGroupCriterion.setType("BiddableAdGroupCriterion");
        this.setAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), BiddableAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableAdGroupCriterion getAdGroupCriterion() {
        return this.adGroupCriterion;
    }

    public void setAdGroupCriterion(BiddableAdGroupCriterion adGroupCriterion) {
        this.adGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupAgeCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupAgeCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupAgeCriterion, String>("Status", new Function<BulkAdGroupAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupAgeCriterion c) {
                AdGroupCriterionStatus status = c.getAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupAgeCriterion c) {
                c.getAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAgeCriterion, Long>("Id", new Function<BulkAdGroupAgeCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupAgeCriterion c) {
                return c.getAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupAgeCriterion c) {
                c.getAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAgeCriterion, Long>("Parent Id", new Function<BulkAdGroupAgeCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupAgeCriterion c) {
                return c.getAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupAgeCriterion c) {
                c.getAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAgeCriterion, String>("Campaign", new Function<BulkAdGroupAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupAgeCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupAgeCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAgeCriterion, String>("Ad Group", new Function<BulkAdGroupAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupAgeCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupAgeCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAgeCriterion, String>("Bid Adjustment", new Function<BulkAdGroupAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupAgeCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupAgeCriterion c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAgeCriterion, String>("Target", new Function<BulkAdGroupAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupAgeCriterion c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof AgeCriterion) {
                    AgeRange ageRange = ((AgeCriterion)c.getAdGroupCriterion().getCriterion()).getAgeRange();
                    return ageRange == null ? null : ageRange.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupAgeCriterion c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof AgeCriterion) {
                    ((AgeCriterion)c.getAdGroupCriterion().getCriterion()).setAgeRange(StringExtensions.parseOptional(v, new Function<String, AgeRange>(){

                        @Override
                        public AgeRange apply(String s) {
                            return AgeRange.fromValue(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

