/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.IntentOption;
import com.microsoft.bingads.v11.campaignmanagement.LocationIntentCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignLocationIntentCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion campaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignLocationIntentCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        LocationIntentCriterion locationIntentCriterion = new LocationIntentCriterion();
        campaignCriterion.setCriterion(locationIntentCriterion);
        campaignCriterion.getCriterion().setType(LocationIntentCriterion.class.getSimpleName());
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getCampaignCriterion() {
        return this.campaignCriterion;
    }

    public void setCampaignCriterion(BiddableCampaignCriterion campaignCriterion) {
        this.campaignCriterion = campaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignLocationIntentCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignLocationIntentCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, String>("Status", new Function<BulkCampaignLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationIntentCriterion c) {
                CampaignCriterionStatus status = c.getCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                c.getCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, Long>("Id", new Function<BulkCampaignLocationIntentCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignLocationIntentCriterion c) {
                return c.getCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                c.getCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, Long>("Parent Id", new Function<BulkCampaignLocationIntentCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignLocationIntentCriterion c) {
                return c.getCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                c.getCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, String>("Campaign", new Function<BulkCampaignLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationIntentCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignLocationIntentCriterion, String>("Target", new Function<BulkCampaignLocationIntentCriterion, String>(){

            @Override
            public String apply(BulkCampaignLocationIntentCriterion c) {
                if (c.getCampaignCriterion().getCriterion() instanceof LocationIntentCriterion) {
                    IntentOption intentOption = ((LocationIntentCriterion)c.getCampaignCriterion().getCriterion()).getIntentOption();
                    return intentOption == null ? null : intentOption.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignLocationIntentCriterion>(){

            @Override
            public void accept(String v, BulkCampaignLocationIntentCriterion c) {
                if (c.getCampaignCriterion().getCriterion() instanceof LocationIntentCriterion) {
                    ((LocationIntentCriterion)c.getCampaignCriterion().getCriterion()).setIntentOption(StringExtensions.parseOptional(v, new Function<String, IntentOption>(){

                        @Override
                        public IntentOption apply(String s) {
                            return IntentOption.fromValue(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

