/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v11.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v11.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v11.campaignmanagement.DeviceCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignDeviceCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion campaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignDeviceCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        DeviceCriterion deviceCriterion = new DeviceCriterion();
        campaignCriterion.setCriterion(deviceCriterion);
        campaignCriterion.getCriterion().setType(DeviceCriterion.class.getSimpleName());
        campaignCriterion.setCriterionBid(bidMultiplier);
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getCampaignCriterion() {
        return this.campaignCriterion;
    }

    public void setCampaignCriterion(BiddableCampaignCriterion campaignCriterion) {
        this.campaignCriterion = campaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignDeviceCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignDeviceCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Status", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                CampaignCriterionStatus status = c.getCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                c.getCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, Long>("Id", new Function<BulkCampaignDeviceCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignDeviceCriterion c) {
                return c.getCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                c.getCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, Long>("Parent Id", new Function<BulkCampaignDeviceCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignDeviceCriterion c) {
                return c.getCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                c.getCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Campaign", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Bid Adjustment", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                if (c.getCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                if (c.getCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Target", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                if (c.getCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getCampaignCriterion().getCriterion()).getDeviceName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                if (c.getCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getCampaignCriterion().getCriterion()).setDeviceName(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("OS Names", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                if (c.getCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getCampaignCriterion().getCriterion()).getOSName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                if (c.getCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getCampaignCriterion().getCriterion()).setOSName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

