/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v11.campaignmanagement.CallAdExtension;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCallAdExtension
extends BulkAdExtension<CallAdExtension> {
    private static List<BulkMapping<BulkCallAdExtension>> MAPPINGS;

    public CallAdExtension getCallAdExtension() {
        return (CallAdExtension)this.getAdExtension();
    }

    public void setCallAdExtension(CallAdExtension value) {
        this.setAdExtension(value);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        CallAdExtension extension = new CallAdExtension();
        extension.setType("CallAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCallAdExtension(), "CallAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCallAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkCallAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkCallAdExtension, String>("Phone Number", new Function<BulkCallAdExtension, String>(){

            @Override
            public String apply(BulkCallAdExtension c) {
                return c.getCallAdExtension().getPhoneNumber();
            }
        }, new BiConsumer<String, BulkCallAdExtension>(){

            @Override
            public void accept(String v, BulkCallAdExtension c) {
                c.getCallAdExtension().setPhoneNumber(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCallAdExtension, String>("Country Code", new Function<BulkCallAdExtension, String>(){

            @Override
            public String apply(BulkCallAdExtension c) {
                return c.getCallAdExtension().getCountryCode();
            }
        }, new BiConsumer<String, BulkCallAdExtension>(){

            @Override
            public void accept(String v, BulkCallAdExtension c) {
                c.getCallAdExtension().setCountryCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCallAdExtension, String>("Call Only", new Function<BulkCallAdExtension, String>(){

            @Override
            public String apply(BulkCallAdExtension c) {
                return StringExtensions.toBooleanBulkString(c.getCallAdExtension().getIsCallOnly());
            }
        }, new BiConsumer<String, BulkCallAdExtension>(){

            @Override
            public void accept(String v, BulkCallAdExtension c) {
                c.getCallAdExtension().setIsCallOnly(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCallAdExtension, String>("Call Tracking Enabled", new Function<BulkCallAdExtension, String>(){

            @Override
            public String apply(BulkCallAdExtension c) {
                return StringExtensions.toBooleanBulkString(c.getCallAdExtension().getIsCallTrackingEnabled());
            }
        }, new BiConsumer<String, BulkCallAdExtension>(){

            @Override
            public void accept(String v, BulkCallAdExtension c) {
                c.getCallAdExtension().setIsCallTrackingEnabled(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCallAdExtension, String>("Toll Free", new Function<BulkCallAdExtension, String>(){

            @Override
            public String apply(BulkCallAdExtension c) {
                return StringExtensions.toBooleanBulkString(c.getCallAdExtension().getRequireTollFreeTrackingNumber());
            }
        }, new BiConsumer<String, BulkCallAdExtension>(){

            @Override
            public void accept(String v, BulkCallAdExtension c) {
                c.getCallAdExtension().setRequireTollFreeTrackingNumber(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

