/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.Status;
import com.microsoft.bingads.v11.campaignmanagement.EntityScope;
import com.microsoft.bingads.v11.campaignmanagement.ProductAudience;
import com.microsoft.bingads.v11.campaignmanagement.ProductAudienceType;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BulkProductAudience
extends SingleRecordBulkEntity {
    private ProductAudience productAudience;
    private Status status;
    private static final List<BulkMapping<BulkProductAudience>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setProductAudience(new ProductAudience());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getProductAudience(), "ProductAudience");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public ProductAudience getProductAudience() {
        return this.productAudience;
    }

    public void setProductAudience(ProductAudience productAudience) {
        this.productAudience = productAudience;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkProductAudience, Object>> m = new ArrayList<SimpleBulkMapping<BulkProductAudience, Object>>();
        m.add(new SimpleBulkMapping<BulkProductAudience, String>("Status", new Function<BulkProductAudience, String>(){

            @Override
            public String apply(BulkProductAudience c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, Long>("Id", new Function<BulkProductAudience, Long>(){

            @Override
            public Long apply(BulkProductAudience c) {
                return c.getProductAudience().getId();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, Long>("Parent Id", new Function<BulkProductAudience, Long>(){

            @Override
            public Long apply(BulkProductAudience c) {
                return c.getProductAudience().getParentId();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setParentId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, String>("Audience", new Function<BulkProductAudience, String>(){

            @Override
            public String apply(BulkProductAudience c) {
                return c.getProductAudience().getName();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, Long>("Audience Search Size", new Function<BulkProductAudience, Long>(){

            @Override
            public Long apply(BulkProductAudience c) {
                return c.getProductAudience().getSearchSize();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setSearchSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, String>("Description", new Function<BulkProductAudience, String>(){

            @Override
            public String apply(BulkProductAudience c) {
                return c.getProductAudience().getDescription();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, Integer>("Membership Duration", new Function<BulkProductAudience, Integer>(){

            @Override
            public Integer apply(BulkProductAudience c) {
                return c.getProductAudience().getMembershipDuration();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setMembershipDuration(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, String>("Scope", new Function<BulkProductAudience, String>(){

            @Override
            public String apply(BulkProductAudience c) {
                return c.getProductAudience().getScope() != null ? c.getProductAudience().getScope().value() : null;
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setScope(StringExtensions.parseOptional(v, new Function<String, EntityScope>(){

                    @Override
                    public EntityScope apply(String value) {
                        return EntityScope.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, Long>("UET Tag Id", new Function<BulkProductAudience, Long>(){

            @Override
            public Long apply(BulkProductAudience c) {
                return c.getProductAudience().getTagId();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setTagId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, Long>("Audience Network Size", new Function<BulkProductAudience, Long>(){

            @Override
            public Long apply(BulkProductAudience c) {
                return c.getProductAudience().getAudienceNetworkSize();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setAudienceNetworkSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, String>("Supported Campaign Types", new Function<BulkProductAudience, String>(){

            @Override
            public String apply(BulkProductAudience c) {
                return StringExtensions.writeArrayOfstring(c.getProductAudience().getSupportedCampaignTypes(), ";");
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                c.getProductAudience().setSupportedCampaignTypes(StringExtensions.parseArrayOfString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkProductAudience, String>("Product Audience Type", new Function<BulkProductAudience, String>(){

            @Override
            public String apply(BulkProductAudience c) {
                Collection<ProductAudienceType> productAudienceTypes = c.getProductAudience().getProductAudienceType();
                if (productAudienceTypes == null || productAudienceTypes.size() == 0) {
                    return null;
                }
                if (productAudienceTypes.size() != 1) {
                    throw new IllegalArgumentException("Only 1 Product Audience Type can be set in ProductAudience");
                }
                return productAudienceTypes.toArray(new ProductAudienceType[productAudienceTypes.size()])[0].value();
            }
        }, new BiConsumer<String, BulkProductAudience>(){

            @Override
            public void accept(String v, BulkProductAudience c) {
                ProductAudienceType productAudienceType = StringExtensions.parseOptional(v, new Function<String, ProductAudienceType>(){

                    @Override
                    public ProductAudienceType apply(String value) {
                        return ProductAudienceType.fromValue(value);
                    }
                });
                if (productAudienceType != null) {
                    c.getProductAudience().setProductAudienceType(Collections.singleton(productAudienceType));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

