/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.OAuthErrorDetails;
import com.microsoft.bingads.OAuthTokenRequestException;
import com.microsoft.bingads.OAuthTokens;
import com.microsoft.bingads.internal.HttpClientWebServiceCaller;
import com.microsoft.bingads.internal.OAuthEndpoints;
import com.microsoft.bingads.internal.OAuthErrorDetailsContract;
import com.microsoft.bingads.internal.OAuthRequestParameters;
import com.microsoft.bingads.internal.OAuthService;
import com.microsoft.bingads.internal.OAuthTokensContract;
import com.microsoft.bingads.internal.OAuthUrlParameters;
import com.microsoft.bingads.internal.WebServiceCaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class UriOAuthService
implements OAuthService {
    private static final String UTF_8 = "UTF-8";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String RESPONSE_TYPE = "response_type";
    private static final String STATE = "state";
    private static final String SCOPE = "scope";
    public static final Map<ApiEnvironment, OAuthEndpoints> endpointUrls = new HashMap<ApiEnvironment, OAuthEndpoints>();
    private final WebServiceCaller webServiceCaller;
    private ObjectMapper mapper;
    private ApiEnvironment environment;

    public UriOAuthService(ApiEnvironment env) {
        this(new HttpClientWebServiceCaller(), env);
    }

    public UriOAuthService(WebServiceCaller caller, ApiEnvironment env) {
        this.webServiceCaller = caller;
        this.mapper = new ObjectMapper();
        this.environment = env;
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    @Override
    public OAuthTokens getAccessTokens(OAuthRequestParameters oAuthParameters) {
        try {
            List<NameValuePair> paramsList = UriOAuthService.generateParamsList(oAuthParameters);
            HttpResponse httpResponse = this.webServiceCaller.post(new URL(endpointUrls.get((Object)this.environment).getTokenRequestUrl()), paramsList);
            InputStream stream = httpResponse.getEntity().getContent();
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                OAuthTokensContract oauthResponse = (OAuthTokensContract)this.mapper.readValue(stream, OAuthTokensContract.class);
                OAuthTokens oAuthTokens = new OAuthTokens(oauthResponse.getAccessToken(), oauthResponse.getAccessTokenExpiresInSeconds(), oauthResponse.getRefreshToken());
                return oAuthTokens;
            }
            try {
                OAuthErrorDetailsContract errorResponse = (OAuthErrorDetailsContract)this.mapper.readValue(stream, OAuthErrorDetailsContract.class);
                OAuthErrorDetails errorDetails = new OAuthErrorDetails(errorResponse.getError(), errorResponse.getDescription());
                throw new OAuthTokenRequestException("Couldn't request OAuth AccessTokens. Please use the getDetails() method to get more information", errorDetails);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        finally {
            this.webServiceCaller.shutDown();
        }
    }

    public static URL getAuthorizationEndpoint(OAuthUrlParameters parameters, ApiEnvironment env) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(CLIENT_ID, parameters.getClientId());
        paramsMap.put(RESPONSE_TYPE, parameters.getResponseType());
        paramsMap.put(REDIRECT_URI, parameters.getRedirectionUri().toString());
        if (parameters.getState() != null && !parameters.getState().isEmpty()) {
            paramsMap.put(STATE, parameters.getState());
        }
        try {
            return new URL(String.format(endpointUrls.get((Object)env).getAuthorizationEndpointUrl(), UriOAuthService.mapToQueryString(paramsMap)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static List<NameValuePair> generateParamsList(OAuthRequestParameters requestParams) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair(CLIENT_ID, requestParams.getClientId()));
        if (requestParams.getClientSecret() != null && !requestParams.getClientSecret().isEmpty()) {
            params.add((NameValuePair)new BasicNameValuePair(CLIENT_SECRET, requestParams.getClientSecret()));
        }
        params.add((NameValuePair)new BasicNameValuePair(GRANT_TYPE, requestParams.getGrantType()));
        params.add((NameValuePair)new BasicNameValuePair(requestParams.getGrantParamName(), requestParams.getGrantValue()));
        params.add((NameValuePair)new BasicNameValuePair(REDIRECT_URI, requestParams.getRedirectionUri().toString()));
        params.add((NameValuePair)new BasicNameValuePair(SCOPE, "bingads.manage"));
        return params;
    }

    private static String mapToQueryString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(URLEncoder.encode(e.getKey(), UTF_8)).append('=').append(URLEncoder.encode(e.getValue(), UTF_8));
        }
        return sb.toString();
    }

    @Override
    public URL getRedirectUrl() {
        return endpointUrls.get((Object)this.environment).getDesktopRedirectUrl();
    }

    static {
        endpointUrls.put(ApiEnvironment.PRODUCTION, new OAuthEndpoints("https://login.live.com/oauth20_desktop.srf", "https://login.live.com/oauth20_token.srf", "https://login.live.com/oauth20_authorize.srf?scope=bingads.manage&%s"));
        endpointUrls.put(ApiEnvironment.SANDBOX, new OAuthEndpoints("https://login.live-int.com/oauth20_desktop.srf", "https://login.live-int.com/oauth20_token.srf", "https://login.live-int.com/oauth20_authorize.srf?&scope=bingads.manage&prompt=login&%s"));
    }

    private static enum HttpMethods {
        POST;

    }
}

