/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v12.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CampaignCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.campaignmanagement.DeviceCriterion;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignDeviceCriterion
extends SingleRecordBulkEntity {
    private BiddableCampaignCriterion biddableCampaignCriterion;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignDeviceCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableCampaignCriterion campaignCriterion = new BiddableCampaignCriterion();
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        DeviceCriterion deviceCriterion = new DeviceCriterion();
        campaignCriterion.setCriterion(deviceCriterion);
        campaignCriterion.getCriterion().setType(DeviceCriterion.class.getSimpleName());
        campaignCriterion.setCriterionBid(bidMultiplier);
        campaignCriterion.setType("BiddableCampaignCriterion");
        this.setBiddableCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableCampaignCriterion(), BiddableCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BiddableCampaignCriterion getBiddableCampaignCriterion() {
        return this.biddableCampaignCriterion;
    }

    public void setBiddableCampaignCriterion(BiddableCampaignCriterion campaignCriterion) {
        this.biddableCampaignCriterion = campaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignDeviceCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignDeviceCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Status", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                CampaignCriterionStatus status = c.getBiddableCampaignCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                c.getBiddableCampaignCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignCriterionStatus>(){

                    @Override
                    public CampaignCriterionStatus apply(String s) {
                        return CampaignCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, Long>("Id", new Function<BulkCampaignDeviceCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignDeviceCriterion c) {
                return c.getBiddableCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                c.getBiddableCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, Long>("Parent Id", new Function<BulkCampaignDeviceCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignDeviceCriterion c) {
                return c.getBiddableCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                c.getBiddableCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Campaign", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Bid Adjustment", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    CriterionBid bid = c.getBiddableCampaignCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    ((BidMultiplier)c.getBiddableCampaignCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Target", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getBiddableCampaignCriterion().getCriterion()).getDeviceName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getBiddableCampaignCriterion().getCriterion()).setDeviceName(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("OS Names", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getBiddableCampaignCriterion().getCriterion()).getOSName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getBiddableCampaignCriterion().getCriterion()).setOSName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

