/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v12.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v12.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupProductAudienceAssociation
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String productAudienceName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupProductAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        adGroupCriterion.setType(BiddableAdGroupCriterion.class.getSimpleName());
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterion(audienceCriterion);
        adGroupCriterion.setCriterionBid(bidMultiplier);
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), "AdGroupProductAudienceAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion adGroupCriterion) {
        this.biddableAdGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getProductAudienceName() {
        return this.productAudienceName;
    }

    public void setProductAudienceName(String productAudienceName) {
        this.productAudienceName = productAudienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, String>("Status", new Function<BulkAdGroupProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupProductAudienceAssociation c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupProductAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, Long>("Id", new Function<BulkAdGroupProductAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupProductAudienceAssociation c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupProductAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, Long>("Parent Id", new Function<BulkAdGroupProductAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupProductAudienceAssociation c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupProductAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, String>("Campaign", new Function<BulkAdGroupProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupProductAudienceAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupProductAudienceAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, String>("Ad Group", new Function<BulkAdGroupProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupProductAudienceAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupProductAudienceAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, String>("Audience", new Function<BulkAdGroupProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupProductAudienceAssociation c) {
                return c.getProductAudienceName();
            }
        }, new BiConsumer<String, BulkAdGroupProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupProductAudienceAssociation c) {
                c.setProductAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, String>("Bid Adjustment", new Function<BulkAdGroupProductAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupProductAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupProductAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductAudienceAssociation, Long>("Audience Id", new Function<BulkAdGroupProductAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupProductAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupProductAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

