/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v12.campaignmanagement.BidMultiplier;
import com.microsoft.bingads.v12.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupInMarketAudienceAssociation
extends SingleRecordBulkEntity {
    private BiddableAdGroupCriterion biddableAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String inMarketAudienceName;
    private PerformanceData performanceData;
    private static final List<BulkMapping<BulkAdGroupInMarketAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BiddableAdGroupCriterion adGroupCriterion = new BiddableAdGroupCriterion();
        adGroupCriterion.setType(BiddableAdGroupCriterion.class.getSimpleName());
        BidMultiplier bidMultiplier = new BidMultiplier();
        bidMultiplier.setType(BidMultiplier.class.getSimpleName());
        AudienceCriterion audienceCriterion = new AudienceCriterion();
        audienceCriterion.setType(AudienceCriterion.class.getSimpleName());
        adGroupCriterion.setCriterion(audienceCriterion);
        adGroupCriterion.setCriterionBid(bidMultiplier);
        this.setBiddableAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBiddableAdGroupCriterion(), "AdGroupInMarketAudienceAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public void setBiddableAdGroupCriterion(BiddableAdGroupCriterion adGroupCriterion) {
        this.biddableAdGroupCriterion = adGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getInMarketAudienceName() {
        return this.inMarketAudienceName;
    }

    public void setInMarketAudienceName(String inMarketAudienceName) {
        this.inMarketAudienceName = inMarketAudienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, String>("Status", new Function<BulkAdGroupInMarketAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupInMarketAudienceAssociation c) {
                AdGroupCriterionStatus status = c.getBiddableAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupInMarketAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupInMarketAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, Long>("Id", new Function<BulkAdGroupInMarketAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupInMarketAudienceAssociation c) {
                return c.getBiddableAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupInMarketAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupInMarketAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, Long>("Parent Id", new Function<BulkAdGroupInMarketAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupInMarketAudienceAssociation c) {
                return c.getBiddableAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupInMarketAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupInMarketAudienceAssociation c) {
                c.getBiddableAdGroupCriterion().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, String>("Campaign", new Function<BulkAdGroupInMarketAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupInMarketAudienceAssociation c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupInMarketAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupInMarketAudienceAssociation c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, String>("Ad Group", new Function<BulkAdGroupInMarketAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupInMarketAudienceAssociation c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupInMarketAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupInMarketAudienceAssociation c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, String>("Audience", new Function<BulkAdGroupInMarketAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupInMarketAudienceAssociation c) {
                return c.getInMarketAudienceName();
            }
        }, new BiConsumer<String, BulkAdGroupInMarketAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupInMarketAudienceAssociation c) {
                c.setInMarketAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, String>("Bid Adjustment", new Function<BulkAdGroupInMarketAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupInMarketAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    CriterionBid bid = c.getBiddableAdGroupCriterion().getCriterionBid();
                    if (bid == null) {
                        return null;
                    }
                    return StringExtensions.toCriterionBidMultiplierBulkString(((BidMultiplier)bid).getMultiplier());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupInMarketAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupInMarketAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BidMultiplier)c.getBiddableAdGroupCriterion().getCriterionBid()).setMultiplier(StringExtensions.nullOrDouble(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupInMarketAudienceAssociation, Long>("Audience Id", new Function<BulkAdGroupInMarketAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupInMarketAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupInMarketAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupInMarketAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

