/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.OfflineConversion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class BulkOfflineConversion
extends SingleRecordBulkEntity {
    private OfflineConversion offlineConversion;
    private static final List<BulkMapping<BulkOfflineConversion>> MAPPINGS;

    public OfflineConversion getOfflineConversion() {
        return this.offlineConversion;
    }

    public void setOfflineConversion(OfflineConversion offlineConversion) {
        this.offlineConversion = offlineConversion;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setOfflineConversion(new OfflineConversion());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getOfflineConversion(), "OfflineConversion");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkOfflineConversion, Object>> m = new ArrayList<SimpleBulkMapping<BulkOfflineConversion, Object>>();
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Conversion Currency Code", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getConversionCurrencyCode();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setConversionCurrencyCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Conversion Name", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getConversionName();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setConversionName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Microsoft Click Id", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getMicrosoftClickId();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setMicrosoftClickId(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, String>("Conversion Time", new Function<BulkOfflineConversion, String>(){

            @Override
            public String apply(BulkOfflineConversion t) {
                if (t.getOfflineConversion().getConversionTime() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getOfflineConversion().getConversionTime().getTime());
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setConversionTime(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkOfflineConversion, Double>("Conversion Value", new Function<BulkOfflineConversion, Double>(){

            @Override
            public Double apply(BulkOfflineConversion c) {
                return c.getOfflineConversion().getConversionValue();
            }
        }, new BiConsumer<String, BulkOfflineConversion>(){

            @Override
            public void accept(String v, BulkOfflineConversion c) {
                c.getOfflineConversion().setConversionValue(StringExtensions.nullOrDouble(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

