/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.AgeCriterion;
import com.microsoft.bingads.v11.campaignmanagement.AgeRange;
import com.microsoft.bingads.v11.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeAgeCriterion
extends SingleRecordBulkEntity {
    private NegativeAdGroupCriterion negativeAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupNegativeAgeCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        AgeCriterion criterion = new AgeCriterion();
        adGroupCriterion.setCriterion(criterion);
        adGroupCriterion.getCriterion().setType(AgeCriterion.class.getSimpleName());
        adGroupCriterion.setType("NegativeAdGroupCriterion");
        this.setNegativeAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeAdGroupCriterion(), NegativeAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeAdGroupCriterion getNegativeAdGroupCriterion() {
        return this.negativeAdGroupCriterion;
    }

    public void setNegativeAdGroupCriterion(NegativeAdGroupCriterion negativeAdGroupCriterion) {
        this.negativeAdGroupCriterion = negativeAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeAgeCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeAgeCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAgeCriterion, String>("Status", new Function<BulkAdGroupNegativeAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeAgeCriterion c) {
                AdGroupCriterionStatus status = c.getNegativeAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAgeCriterion c) {
                c.getNegativeAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAgeCriterion, Long>("Id", new Function<BulkAdGroupNegativeAgeCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeAgeCriterion c) {
                return c.getNegativeAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAgeCriterion c) {
                c.getNegativeAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAgeCriterion, Long>("Parent Id", new Function<BulkAdGroupNegativeAgeCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeAgeCriterion c) {
                return c.getNegativeAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAgeCriterion c) {
                c.getNegativeAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAgeCriterion, String>("Campaign", new Function<BulkAdGroupNegativeAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeAgeCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAgeCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAgeCriterion, String>("Ad Group", new Function<BulkAdGroupNegativeAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeAgeCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAgeCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeAgeCriterion, String>("Target", new Function<BulkAdGroupNegativeAgeCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeAgeCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof AgeCriterion) {
                    AgeRange ageRange = ((AgeCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getAgeRange();
                    return ageRange == null ? null : ageRange.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeAgeCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeAgeCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof AgeCriterion) {
                    ((AgeCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setAgeRange(AgeRange.fromValue(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

