/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.v12.campaignmanagement.ArrayOfProductCondition;
import com.microsoft.bingads.v12.campaignmanagement.ProductCondition;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import java.util.List;

class ProductConditionHelper {
    public static final int MaxNumberOfConditions = 8;

    ProductConditionHelper() {
    }

    public static void addRowValuesFromConditions(ArrayOfProductCondition arrayOfProductCondition, RowValues rowValues) {
        List<ProductCondition> conditions = arrayOfProductCondition.getProductConditions();
        for (int i = 1; i <= conditions.size(); ++i) {
            rowValues.put("Product Condition " + i, conditions.get(i - 1).getOperand());
            rowValues.put("Product Value " + i, conditions.get(i - 1).getAttribute());
        }
    }

    public static void addConditionsFromRowValues(RowValues values, ArrayOfProductCondition productConditionArray) {
        List<ProductCondition> conditions = productConditionArray.getProductConditions();
        for (int i = 1; i <= 8; ++i) {
            String productCondition = values.tryGet("Product Condition " + i);
            String productValue = values.tryGet("Product Value " + i);
            if (productCondition == null || productCondition.isEmpty() || productValue == null || productValue.isEmpty()) continue;
            ProductCondition condition = new ProductCondition();
            condition.setAttribute(productValue);
            condition.setOperand(productCondition);
            conditions.add(condition);
        }
    }
}

