/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v11.campaignmanagement.AppAdExtension;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAppAdExtension
extends BulkAdExtension<AppAdExtension> {
    private static final List<BulkMapping<BulkAppAdExtension>> MAPPINGS;

    public AppAdExtension getAppAdExtension() {
        return (AppAdExtension)this.getAdExtension();
    }

    public void setAppAdExtension(AppAdExtension appAdExtension) {
        this.setAdExtension(appAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        AppAdExtension extension = new AppAdExtension();
        extension.setType("AppAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAppAdExtension(), "AppAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAppAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkAppAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkAppAdExtension, String>("App Platform", new Function<BulkAppAdExtension, String>(){

            @Override
            public String apply(BulkAppAdExtension c) {
                return c.getAppAdExtension().getAppPlatform();
            }
        }, new BiConsumer<String, BulkAppAdExtension>(){

            @Override
            public void accept(String v, BulkAppAdExtension c) {
                c.getAppAdExtension().setAppPlatform(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAppAdExtension, String>("App Id", new Function<BulkAppAdExtension, String>(){

            @Override
            public String apply(BulkAppAdExtension c) {
                return c.getAppAdExtension().getAppStoreId();
            }
        }, new BiConsumer<String, BulkAppAdExtension>(){

            @Override
            public void accept(String v, BulkAppAdExtension c) {
                c.getAppAdExtension().setAppStoreId(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAppAdExtension, String>("Destination Url", new Function<BulkAppAdExtension, String>(){

            @Override
            public String apply(BulkAppAdExtension c) {
                return c.getAppAdExtension().getDestinationUrl();
            }
        }, new BiConsumer<String, BulkAppAdExtension>(){

            @Override
            public void accept(String v, BulkAppAdExtension c) {
                c.getAppAdExtension().setDestinationUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAppAdExtension, String>("Text", new Function<BulkAppAdExtension, String>(){

            @Override
            public String apply(BulkAppAdExtension c) {
                return c.getAppAdExtension().getDisplayText();
            }
        }, new BiConsumer<String, BulkAppAdExtension>(){

            @Override
            public void accept(String v, BulkAppAdExtension c) {
                c.getAppAdExtension().setDisplayText(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

