/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v11.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v11.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v11.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v11.campaignmanagement.ProfileCriterion;
import com.microsoft.bingads.v11.internal.bulk.BulkMapping;
import com.microsoft.bingads.v11.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v11.internal.bulk.RowValues;
import com.microsoft.bingads.v11.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v11.internal.bulk.StringExtensions;
import com.microsoft.bingads.v11.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAdGroupNegativeProfileCriterion
extends SingleRecordBulkEntity {
    private NegativeAdGroupCriterion negativeAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private String profileName;
    private static final List<BulkMapping<BulkAdGroupNegativeProfileCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        ProfileCriterion criterion = new ProfileCriterion();
        adGroupCriterion.setCriterion(criterion);
        adGroupCriterion.getCriterion().setType(ProfileCriterion.class.getSimpleName());
        adGroupCriterion.setType("NegativeAdGroupCriterion");
        this.setProfileType(criterion);
        this.setNegativeAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public abstract void setProfileType(ProfileCriterion var1);

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeAdGroupCriterion(), NegativeAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeAdGroupCriterion getNegativeAdGroupCriterion() {
        return this.negativeAdGroupCriterion;
    }

    public void setNegativeAdGroupCriterion(NegativeAdGroupCriterion negativeAdGroupCriterion) {
        this.negativeAdGroupCriterion = negativeAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, String>("Status", new Function<BulkAdGroupNegativeProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProfileCriterion c) {
                AdGroupCriterionStatus status = c.getNegativeAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                c.getNegativeAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, Long>("Id", new Function<BulkAdGroupNegativeProfileCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeProfileCriterion c) {
                return c.getNegativeAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                c.getNegativeAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, Long>("Parent Id", new Function<BulkAdGroupNegativeProfileCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeProfileCriterion c) {
                return c.getNegativeAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                c.getNegativeAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, String>("Campaign", new Function<BulkAdGroupNegativeProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProfileCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, String>("Ad Group", new Function<BulkAdGroupNegativeProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProfileCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, String>("Profile", new Function<BulkAdGroupNegativeProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProfileCriterion c) {
                return c.getProfileName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                c.setProfileName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, Long>("Profile Id", new Function<BulkAdGroupNegativeProfileCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeProfileCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof ProfileCriterion) {
                    return ((ProfileCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getProfileId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof ProfileCriterion) {
                    ((ProfileCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setProfileId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                        @Override
                        public Long apply(String s) {
                            return Long.parseLong(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

