/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.internal.bulk;

import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.LocationTargetType;
import com.microsoft.bingads.v10.bulk.entities.Status;
import com.microsoft.bingads.v10.campaignmanagement.AdDistribution;
import com.microsoft.bingads.v10.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.v10.campaignmanagement.AdGroupRemarketingListAssociationStatus;
import com.microsoft.bingads.v10.campaignmanagement.AdRotation;
import com.microsoft.bingads.v10.campaignmanagement.AdRotationType;
import com.microsoft.bingads.v10.campaignmanagement.AdStatus;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfCustomParameter;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfDayTime;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfKeyValuePairOfstringstring;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOflong;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v10.campaignmanagement.Bid;
import com.microsoft.bingads.v10.campaignmanagement.BiddingScheme;
import com.microsoft.bingads.v10.campaignmanagement.BusinessGeoCodeStatus;
import com.microsoft.bingads.v10.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v10.campaignmanagement.CustomParameter;
import com.microsoft.bingads.v10.campaignmanagement.CustomParameters;
import com.microsoft.bingads.v10.campaignmanagement.Date;
import com.microsoft.bingads.v10.campaignmanagement.Day;
import com.microsoft.bingads.v10.campaignmanagement.DayTime;
import com.microsoft.bingads.v10.campaignmanagement.EnhancedCpcBiddingScheme;
import com.microsoft.bingads.v10.campaignmanagement.FixedBid;
import com.microsoft.bingads.v10.campaignmanagement.InheritFromParentBiddingScheme;
import com.microsoft.bingads.v10.campaignmanagement.KeyValuePairOfstringstring;
import com.microsoft.bingads.v10.campaignmanagement.ManualCpcBiddingScheme;
import com.microsoft.bingads.v10.campaignmanagement.MatchType;
import com.microsoft.bingads.v10.campaignmanagement.MaxClicksBiddingScheme;
import com.microsoft.bingads.v10.campaignmanagement.MaxConversionsBiddingScheme;
import com.microsoft.bingads.v10.campaignmanagement.Minute;
import com.microsoft.bingads.v10.campaignmanagement.TargetCpaBiddingScheme;
import java.io.File;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;

public class StringExtensions {
    private static final String UNKNOWN_DEVICE_PREFERENCE = "Unknown device preference";
    private static final String ALL = "All";
    private static final String MOBILE = "Mobile";
    private static final String DATE_OUTPUT_FORMAT = "%d/%d/%d";
    private static final String urlSplitter = ";\\s*(?=https?://)";
    private static final String customParameterSplitter = "(?<!\\\\);\\s*";
    private static final Pattern customKvPattern = Pattern.compile("^\\{_(.*?)\\}=(.*$)");
    private static final Pattern dayTimePattern = Pattern.compile("\\((Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday)\\[(\\d\\d?):(\\d\\d)-(\\d\\d?):(\\d\\d)\\]\\)");
    public static SimpleDateFormat SYNC_TIME_FORMATTER = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public static String toKeywordBidBulkString(Bid bid) {
        if (bid == null) {
            return null;
        }
        if (bid.getAmount() == null) {
            return "delete_value";
        }
        return StringExtensions.toBulkString(bid.getAmount());
    }

    public static Long nullOrLong(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static BigDecimal nullOrBigDecimal(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return BigDecimal.valueOf(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static <T> String toBulkString(T value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Double nullOrDouble(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer parseOptionalInteger(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public static int parseInt(String value) {
        return Integer.parseInt(value);
    }

    public static Date parseDate(String headerValue) throws ParseException {
        if (headerValue == null || headerValue.length() == 0) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        format.setLenient(false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(format.parse(headerValue));
        Date bingDate = new Date();
        bingDate.setDay(calendar.get(5));
        bingDate.setMonth(calendar.get(2) + 1);
        bingDate.setYear(calendar.get(1));
        return bingDate;
    }

    public static String isOnOrOff(Collection<AdDistribution> values, AdDistribution lookingFor) {
        if (values == null) {
            return null;
        }
        return values.contains((Object)lookingFor) ? "On" : "Off";
    }

    public static Bid parseAdGroupBid(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        Bid bid = new Bid();
        if (v.equals("delete_value")) {
            bid.setAmount(0.0);
            return bid;
        }
        Double bidAmount = StringExtensions.nullOrDouble(v);
        if (bidAmount != null) {
            bid.setAmount(bidAmount);
            return bid;
        }
        return null;
    }

    public static Bid parseKeywordBid(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        Bid bid = new Bid();
        if (v.equals("delete_value")) {
            bid.setAmount(null);
            return bid;
        }
        Double bidAmount = StringExtensions.nullOrDouble(v);
        if (bidAmount != null) {
            bid.setAmount(bidAmount);
            return bid;
        }
        return null;
    }

    public static java.util.Date parseSyncTime(String v) throws ParseException {
        if (v == null || v.isEmpty()) {
            return null;
        }
        return SYNC_TIME_FORMATTER.parse(v);
    }

    public static String toDateBulkString(Date c) {
        if (c == null) {
            return null;
        }
        return String.format(DATE_OUTPUT_FORMAT, c.getMonth(), c.getDay(), c.getYear());
    }

    public static String toScheduleDateBulkString(Date c) {
        if (c == null || c.getMonth() == 0 && c.getDay() == 0 && c.getYear() == 0) {
            return "delete_value";
        }
        return String.format(DATE_OUTPUT_FORMAT, c.getMonth(), c.getDay(), c.getYear());
    }

    public static AdRotation parseAdRotation(String v) {
        if ("delete_value".equals(v)) {
            return null;
        }
        if (v == null || v.isEmpty()) {
            return null;
        }
        try {
            AdRotation rotation = new AdRotation();
            rotation.setType(AdRotationType.fromValue(v));
            return rotation;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static AdDistribution parseSearchAdDistribution(String v) {
        if (StringExtensions.isTurnedOn(v)) {
            return AdDistribution.SEARCH;
        }
        return null;
    }

    public static AdDistribution parseContentAdDistribution(String v) {
        if (StringExtensions.isTurnedOn(v)) {
            return AdDistribution.CONTENT;
        }
        return null;
    }

    public static boolean isTurnedOn(String v) {
        return v != null && v.length() != 0 && !"delete_value".equals(v) && v.equals("On");
    }

    public static <T> T parseOptionalUpperCase(String v, Function<String, T> parse) {
        if (v == null | v.length() == 0) {
            return null;
        }
        return StringExtensions.parseOptional(v.substring(0, 1) + v.substring(1, v.length()).toLowerCase(), parse);
    }

    public static <T> T parseOptional(String v, Function<String, T> parse) {
        if (v == null || v.length() == 0) {
            return null;
        }
        return parse.apply(v);
    }

    public static <T> JAXBElement<T> parseJAXBElement(String v, Function<String, T> parse, Function<T, JAXBElement<T>> factory) {
        if (v == null || v.length() == 0) {
            return null;
        }
        return factory.apply(parse.apply(v));
    }

    public static String toOptionalBulkString(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return "delete_value";
        }
        return value;
    }

    public static String getValueOrEmptyString(String v) {
        if (v == null || v.isEmpty()) {
            return "";
        }
        return v;
    }

    public static Long parseDevicePreference(String v) {
        if (v == null || v.isEmpty() || v.equals(ALL)) {
            return 0L;
        }
        if (v.equals(MOBILE)) {
            return 30001L;
        }
        throw new UnsupportedOperationException(UNKNOWN_DEVICE_PREFERENCE);
    }

    public static String toDevicePreferenceBulkString(Long pref) {
        if (pref == null || pref.equals(0L)) {
            return ALL;
        }
        if (pref.equals(30001L)) {
            return MOBILE;
        }
        throw new UnsupportedOperationException(UNKNOWN_DEVICE_PREFERENCE);
    }

    public static <T> T parse(String v, Function<String, T> parser) {
        return parser.apply(v);
    }

    public static String toMatchTypeBulkString(MatchType type) {
        if (type == null) {
            return null;
        }
        return type.value();
    }

    public static String toAdRotationBulkString(AdRotation c) {
        if (c == null || c.getType() == null) {
            return null;
        }
        return StringExtensions.toBulkString(c.getType().value());
    }

    public static String toAdGroupBidBulkString(Bid bid) {
        if (bid == null || bid.getAmount() == null) {
            return null;
        }
        if (bid.getAmount() == 0.0) {
            return "delete_value";
        }
        return bid.getAmount().toString();
    }

    public static CriterionBid parseFixedAdGroupBid(String v) {
        Bid bid = StringExtensions.parseAdGroupBid(v);
        if (bid == null) {
            return null;
        }
        FixedBid fixedBid = new FixedBid();
        fixedBid.setBid(bid);
        return fixedBid;
    }

    public static String toAdStatusBulkString(AdStatus status) {
        if (status == null) {
            return null;
        }
        return status.value();
    }

    public static String toGeoCodeStatusBulkString(BusinessGeoCodeStatus geoCodeStatus) {
        if (geoCodeStatus == null) {
            return null;
        }
        return geoCodeStatus.value();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static Integer parseLatLngInMicroDegrees(String v) {
        Double decimalDegrees = StringExtensions.parseOptional(v, new Function<String, Double>(){

            @Override
            public Double apply(String value) {
                return Double.parseDouble(value);
            }
        });
        if (decimalDegrees == null) {
            return null;
        }
        return (int)Math.round(decimalDegrees * 1000000.0);
    }

    public static String toBooleanBulkString(Boolean isCallOnly) {
        if (isCallOnly == null) {
            return null;
        }
        if (isCallOnly.booleanValue()) {
            return "True";
        }
        return "False";
    }

    public static String toAdExtensionStatusBulkString(AdExtensionStatus status) {
        if (status == null) {
            return null;
        }
        return status.value();
    }

    public static String toAdGroupRemarketingListAssociationStatusBulkString(AdGroupRemarketingListAssociationStatus status) {
        if (status == null) {
            return null;
        }
        return status.value();
    }

    public static String toStatusBulkString(Status status) {
        if (status == null) {
            return null;
        }
        return status.value();
    }

    public static Minute parseMinute(String s) {
        int minuteNumber = Integer.parseInt(s);
        switch (minuteNumber) {
            case 0: {
                return Minute.ZERO;
            }
            case 15: {
                return Minute.FIFTEEN;
            }
            case 30: {
                return Minute.THIRTY;
            }
            case 45: {
                return Minute.FORTY_FIVE;
            }
        }
        throw new IllegalArgumentException("Unknown minute");
    }

    public static String toMinuteBulkString(Minute minute) {
        switch (minute) {
            case ZERO: {
                return "0";
            }
            case FIFTEEN: {
                return "15";
            }
            case THIRTY: {
                return "30";
            }
            case FORTY_FIVE: {
                return "45";
            }
        }
        throw new IllegalArgumentException("Unknown minute");
    }

    public static Day parseDay(String s) {
        if (s.toLowerCase().equals("sunday")) {
            return Day.SUNDAY;
        }
        if (s.toLowerCase().equals("monday")) {
            return Day.MONDAY;
        }
        if (s.toLowerCase().equals("tuesday")) {
            return Day.TUESDAY;
        }
        if (s.toLowerCase().equals("wednesday")) {
            return Day.WEDNESDAY;
        }
        if (s.toLowerCase().equals("thursday")) {
            return Day.THURSDAY;
        }
        if (s.toLowerCase().equals("friday")) {
            return Day.FRIDAY;
        }
        if (s.toLowerCase().equals("saturday")) {
            return Day.SATURDAY;
        }
        throw new IllegalArgumentException("Unknown day");
    }

    public static LocationTargetType parseLocationTargetType(String s) {
        if (s.equals("Metro Area")) {
            return LocationTargetType.METRO_AREA;
        }
        if (s.equals("Postal Code")) {
            return LocationTargetType.POSTAL_CODE;
        }
        return LocationTargetType.fromValue(s);
    }

    public static String toLocationTargetTypeBulkString(LocationTargetType locationTargetType) {
        if (locationTargetType == null) {
            return null;
        }
        switch (locationTargetType) {
            case METRO_AREA: {
                return "Metro Area";
            }
            case POSTAL_CODE: {
                return "Postal Code";
            }
        }
        return locationTargetType.value();
    }

    public static String join(String separator, List<String> strings) {
        if (strings == null) {
            return null;
        }
        String result = "";
        Integer i = 0;
        while (i < strings.size() - 1) {
            result = result + strings.get(i) + separator;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result = result + strings.get(strings.size() - 1);
        return result;
    }

    public static String getFileExtension(String fileName) {
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            return fileName.substring(indexOfDot);
        }
        return fileName;
    }

    public static String getFileNameWithoutExtension(File file) {
        String fileName = file.getName();
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            return fileName.substring(0, indexOfDot);
        }
        return fileName;
    }

    public static File changeFileExtension(File file, String newExtension) {
        String fullFileName = file.toString();
        int indexOfDot = fullFileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            return new File(fullFileName.substring(0, indexOfDot) + newExtension);
        }
        return new File(fullFileName + newExtension);
    }

    public static String writeUrls(String separator, ArrayOfstring strings) {
        if (strings == null) {
            return null;
        }
        if (strings.getStrings().size() == 0) {
            return "delete_value";
        }
        StringBuilder result = new StringBuilder("");
        int length = strings.getStrings().size();
        Integer i = 0;
        while (i < length - 1) {
            result.append(strings.getStrings().get(i) + separator);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result.append(strings.getStrings().get(length - 1));
        return result.toString();
    }

    public static List<String> parseUrls(String s) {
        String[] urls;
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        ArrayList<String> urlArray = new ArrayList<String>();
        for (String tmp : urls = s.split(urlSplitter)) {
            if (StringExtensions.isNullOrEmpty(tmp) || ";".equals(tmp)) continue;
            urlArray.add(tmp);
        }
        return urlArray;
    }

    public static String toCustomParaBulkString(CustomParameters parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayOfCustomParameter customParaArray = parameters.getParameters();
        if (customParaArray == null || customParaArray.getCustomParameters().size() == 0) {
            return "delete_value";
        }
        String result = "";
        int length = customParaArray.getCustomParameters().size();
        for (int i = 0; i < length - 1; ++i) {
            CustomParameter cp = customParaArray.getCustomParameters().get(i);
            String tmp = String.format("{_%s}=%s", cp.getKey(), StringExtensions.escapeParameterText(cp.getValue()));
            result = result + tmp + "; ";
        }
        CustomParameter cp = customParaArray.getCustomParameters().get(length - 1);
        result = result + String.format("{_%s}=%s", cp.getKey(), StringExtensions.escapeParameterText(cp.getValue()));
        return result;
    }

    private static String escapeParameterText(String text) {
        StringBuffer buffer = new StringBuffer(text.length() * 2);
        for (char c : text.toCharArray()) {
            if (c == ';' || c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String unEscapeParameterText(String text) {
        StringBuffer buffer = new StringBuffer(text.length());
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) == '\\') {
                ++i;
            }
            if (i >= length) continue;
            buffer.append(text.charAt(i));
        }
        return buffer.toString();
    }

    public static CustomParameters parseCustomParameters(String s) throws Exception {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        String[] parameters = s.split(customParameterSplitter);
        ArrayOfCustomParameter customParametersArray = new ArrayOfCustomParameter();
        for (String p : parameters) {
            if (StringExtensions.isNullOrEmpty(p)) continue;
            Matcher match = customKvPattern.matcher(p = p.trim());
            if (match.find()) {
                CustomParameter param = new CustomParameter();
                param.setKey(match.group(1));
                param.setValue(StringExtensions.unEscapeParameterText(match.group(2)));
                customParametersArray.getCustomParameters().add(param);
                continue;
            }
            throw new IllegalArgumentException(String.format("Bad format for CustomParameters: %s", s));
        }
        CustomParameters result = new CustomParameters();
        result.setParameters(customParametersArray);
        return result;
    }

    public static BiddingScheme parseBiddingScheme(String s) throws Exception {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        BiddingScheme biddingScheme = null;
        if (s.equals("EnhancedCpc")) {
            biddingScheme = new EnhancedCpcBiddingScheme();
            biddingScheme.setType("EnhancedCpc");
        } else if (s.equals("InheritFromParent")) {
            biddingScheme = new InheritFromParentBiddingScheme();
            biddingScheme.setType("InheritFromParent");
        } else if (s.equals("MaxConversions")) {
            biddingScheme = new MaxConversionsBiddingScheme();
            biddingScheme.setType("MaxConversions");
        } else if (s.equals("ManualCpc")) {
            biddingScheme = new ManualCpcBiddingScheme();
            biddingScheme.setType("ManualCpc");
        } else if (s.equals("TargetCpa")) {
            biddingScheme = new TargetCpaBiddingScheme();
            biddingScheme.setType("TargetCpa");
        } else if (s.equals("MaxClicks")) {
            biddingScheme = new MaxClicksBiddingScheme();
            biddingScheme.setType("MaxClicks");
        } else {
            throw new IllegalArgumentException(String.format("Unknown value for Bid Strategy Type : %s", s));
        }
        return biddingScheme;
    }

    public static String toBiddingSchemeBulkString(BiddingScheme biddingScheme) throws Exception {
        if (biddingScheme == null) {
            return null;
        }
        if (biddingScheme instanceof EnhancedCpcBiddingScheme) {
            return "EnhancedCpc";
        }
        if (biddingScheme instanceof InheritFromParentBiddingScheme) {
            return "InheritFromParent";
        }
        if (biddingScheme instanceof MaxConversionsBiddingScheme) {
            return "MaxConversions";
        }
        if (biddingScheme instanceof ManualCpcBiddingScheme) {
            return "ManualCpc";
        }
        if (biddingScheme instanceof TargetCpaBiddingScheme) {
            return "TargetCpa";
        }
        if (biddingScheme instanceof MaxClicksBiddingScheme) {
            return "MaxClicks";
        }
        throw new IllegalArgumentException("Unknown bidding scheme");
    }

    public static String toNativePreferenceBulkString(ArrayOfKeyValuePairOfstringstring parameters) {
        if (parameters == null) {
            return null;
        }
        List<KeyValuePairOfstringstring> listOfKeyValuePair = parameters.getKeyValuePairOfstringstrings();
        for (KeyValuePairOfstringstring keyValuePair : listOfKeyValuePair) {
            if (!keyValuePair.getKey().equals("NativePreference")) continue;
            String value = keyValuePair.getValue().toLowerCase();
            if (value.equals("true")) {
                return "Native";
            }
            if (value.equals("false")) {
                return ALL;
            }
            throw new IllegalArgumentException(String.format("Unknown value for Native Preference : %s", value));
        }
        return null;
    }

    public static List<Long> parseImageMediaIds(String v) {
        String[] ids;
        if (StringExtensions.isNullOrEmpty(v)) {
            return null;
        }
        ArrayList<Long> idArray = new ArrayList<Long>();
        for (String tmp : ids = v.split(";")) {
            if (StringExtensions.isNullOrEmpty(tmp) || ";".equals(tmp)) continue;
            idArray.add(Long.parseLong(tmp));
        }
        return idArray;
    }

    public static String writeMediaIds(String separator, ArrayOflong ids) {
        if (ids == null) {
            return null;
        }
        if (ids.getLongs().size() == 0) {
            return "delete_value";
        }
        StringBuilder result = new StringBuilder("");
        int length = ids.getLongs().size();
        Integer i = 0;
        while (i < length - 1) {
            result.append(ids.getLongs().get(i) + separator);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result.append(ids.getLongs().get(length - 1));
        return result.toString();
    }

    public static ArrayOfstring parseStructuredSnippetValues(String v) {
        String[] values;
        if (StringExtensions.isNullOrEmpty(v)) {
            return null;
        }
        ArrayOfstring valueArray = new ArrayOfstring();
        for (String tmp : values = v.split(";")) {
            if (StringExtensions.isNullOrEmpty(tmp) || ";".equals(tmp)) continue;
            valueArray.getStrings().add(tmp);
        }
        return valueArray;
    }

    public static String writeStructuredSnippetValues(String separator, ArrayOfstring values) {
        if (values == null || values.getStrings().size() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder("");
        int length = values.getStrings().size();
        Integer i = 0;
        while (i < length - 1) {
            result.append(values.getStrings().get(i) + separator);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result.append(values.getStrings().get(length - 1));
        return result.toString();
    }

    public static String toDayTimeRangesBulkString(ArrayOfDayTime arrayOfDayTime) {
        if (arrayOfDayTime == null) {
            return "delete_value";
        }
        List<DayTime> dayTimeRanges = arrayOfDayTime.getDayTimes();
        if (dayTimeRanges == null || dayTimeRanges.size() == 0) {
            return "delete_value";
        }
        String result = "";
        int length = dayTimeRanges.size();
        for (int i = 0; i < length - 1; ++i) {
            DayTime dayTime = dayTimeRanges.get(i);
            String tmp = String.format(String.format("(%s[%02d:%02d-%02d:%02d])", dayTime.getDay().value(), dayTime.getStartHour(), Integer.parseInt(StringExtensions.toMinuteBulkString(dayTime.getStartMinute())), dayTime.getEndHour(), Integer.parseInt(StringExtensions.toMinuteBulkString(dayTime.getEndMinute()))), new Object[0]);
            result = result + tmp + ";";
        }
        DayTime dayTime = dayTimeRanges.get(length - 1);
        result = result + String.format(String.format("(%s[%02d:%02d-%02d:%02d])", dayTime.getDay().value(), dayTime.getStartHour(), Integer.parseInt(StringExtensions.toMinuteBulkString(dayTime.getStartMinute())), dayTime.getEndHour(), Integer.parseInt(StringExtensions.toMinuteBulkString(dayTime.getEndMinute()))), new Object[0]);
        return result;
    }

    public static ArrayOfDayTime parseDayTimeRanges(String s) {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        String[] parameters = s.split(";");
        ArrayList<DayTime> dayTimeArray = new ArrayList<DayTime>();
        for (String p : parameters) {
            if (StringExtensions.isNullOrEmpty(p)) continue;
            Matcher match = dayTimePattern.matcher(p = p.trim());
            if (match.find()) {
                DayTime dayTime = new DayTime();
                dayTime.setDay(StringExtensions.parseDay(match.group(1)));
                dayTime.setStartHour(Integer.parseInt(match.group(2)));
                dayTime.setStartMinute(StringExtensions.parseMinute(match.group(3)));
                dayTime.setEndHour(Integer.parseInt(match.group(4)));
                dayTime.setEndMinute(StringExtensions.parseMinute(match.group(5)));
                dayTimeArray.add(dayTime);
                continue;
            }
            throw new IllegalArgumentException(String.format("Bad format for DateTimeRanges: %s", s));
        }
        ArrayOfDayTime result = new ArrayOfDayTime();
        result.getDayTimes().addAll(dayTimeArray);
        return result;
    }

    public static String toUseSearcherTimeZoneBulkString(Boolean useSearcherTimeZone) {
        if (useSearcherTimeZone == null) {
            return "delete_value";
        }
        return useSearcherTimeZone != false ? "true" : "false";
    }

    public static Boolean parseUseSearcherTimeZone(String s) {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        if (s.toLowerCase().equals("true")) {
            return true;
        }
        if (s.toLowerCase().equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Unknown value for Use Searcher Time Zone : %s", s));
    }
}

