/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.BulkTargetBid;
import com.microsoft.bingads.v10.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.v10.bulk.entities.LocationTargetType;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BulkLocationTargetBidWithStringLocation
extends BulkTargetBid {
    private String location;
    private LocationTargetType locationType;
    private static final List<BulkMapping<BulkLocationTargetBidWithStringLocation>> MAPPINGS;

    BulkLocationTargetBidWithStringLocation(BulkTargetIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public LocationTargetType getLocationType() {
        return this.locationType;
    }

    public void setLocationType(LocationTargetType locationType) {
        this.locationType = locationType;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkLocationTargetBidWithStringLocation, String>> m = new ArrayList<SimpleBulkMapping<BulkLocationTargetBidWithStringLocation, String>>();
        m.add(new SimpleBulkMapping<BulkLocationTargetBidWithStringLocation, String>("Target", new Function<BulkLocationTargetBidWithStringLocation, String>(){

            @Override
            public String apply(BulkLocationTargetBidWithStringLocation c) {
                return c.getLocation();
            }
        }, new BiConsumer<String, BulkLocationTargetBidWithStringLocation>(){

            @Override
            public void accept(String v, BulkLocationTargetBidWithStringLocation c) {
                c.setLocation(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationTargetBidWithStringLocation, String>("Sub Type", new Function<BulkLocationTargetBidWithStringLocation, String>(){

            @Override
            public String apply(BulkLocationTargetBidWithStringLocation c) {
                return StringExtensions.toLocationTargetTypeBulkString(c.getLocationType());
            }
        }, new BiConsumer<String, BulkLocationTargetBidWithStringLocation>(){

            @Override
            public void accept(String v, BulkLocationTargetBidWithStringLocation c) {
                c.setLocationType(StringExtensions.parseLocationTargetType(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

