/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.customerbilling.ICustomerBillingService;
import com.microsoft.bingads.customermanagement.ICustomerManagementService;
import com.microsoft.bingads.internal.ServiceFactory;
import com.microsoft.bingads.internal.ServiceInfo;
import com.microsoft.bingads.reporting.IReportingService;
import com.microsoft.bingads.v10.adinsight.IAdInsightService;
import com.microsoft.bingads.v10.bulk.IBulkService;
import com.microsoft.bingads.v10.campaignmanagement.ICampaignManagementService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.spi.Provider;

class ServiceFactoryImpl
implements ServiceFactory {
    private static final String VERSION = "10.4.6";
    private static final Map<Class, ServiceInfo> endpoints = new HashMap<Class, ServiceInfo>(){
        {
            this.put(ICustomerBillingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Api/Billing/v9/CustomerBillingService.svc");
                }
            });
            this.put(ICustomerManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Api/CustomerManagement/v9/CustomerManagementService.svc");
                    this.setSandboxUrl("https://clientcenter.api.sandbox.bingads.microsoft.com/Api/CustomerManagement/v9/CustomerManagementService.svc");
                }
            });
            this.put(IReportingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://api.bingads.microsoft.com/Api/Advertiser/Reporting/v9/ReportingService.svc");
                    this.setSandboxUrl("https://api.sandbox.bingads.microsoft.com/Api/Advertiser/Reporting/v9/ReportingService.svc");
                }
            });
            this.put(ICampaignManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://campaign.api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v10/CampaignManagementService.svc");
                    this.setSandboxUrl("https://campaign.api.sandbox.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v10/CampaignManagementService.svc");
                }
            });
            this.put(IAdInsightService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://adinsight.api.bingads.microsoft.com/Api/Advertiser/AdInsight/V10/AdInsightService.svc");
                    this.setSandboxUrl("https://adinsight.api.sandbox.bingads.microsoft.com/Api/Advertiser/AdInsight/V10/AdInsightService.svc");
                }
            });
            this.put(IBulkService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://bulk.api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v10/BulkService.svc");
                    this.setSandboxUrl("https://bulk.api.sandbox.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v10/BulkService.svc");
                }
            });
        }
    };

    ServiceFactoryImpl() {
    }

    @Override
    public Service createService(Class serviceInterface, ApiEnvironment env) {
        QName qName = this.getServiceQname(serviceInterface);
        if (Provider.provider().getClass().getName().contains("org.apache.cxf")) {
            return Service.create((QName)qName);
        }
        try {
            return Service.create((URL)new URL(this.getServiceUrl(serviceInterface, env) + "?wsdl"), (QName)qName);
        }
        catch (MalformedURLException e) {
            throw new InternalException(e);
        }
    }

    private String getServiceUrl(Class serviceInterface, ApiEnvironment env) {
        String serviceUrl = this.getServiceUrlFromConfig(serviceInterface);
        if (serviceUrl == null) {
            ServiceInfo serviceInfo = endpoints.get(serviceInterface);
            serviceUrl = serviceInfo.GetUrl(env);
        }
        return serviceUrl;
    }

    private QName getServiceQname(Class serviceInterface) {
        WebService webServiceAnnotation = serviceInterface.getAnnotation(WebService.class);
        String serviceName = webServiceAnnotation.name();
        if (serviceName.startsWith("I")) {
            serviceName = serviceName.substring(1);
        }
        QName qName = new QName(webServiceAnnotation.targetNamespace(), serviceName);
        return qName;
    }

    @Override
    public <T> T createProxyFromService(Service service, ApiEnvironment env, Class<T> serviceInterface) {
        Object port = service.getPort(serviceInterface);
        String serviceUrl = this.getServiceUrl(serviceInterface, env);
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", serviceUrl);
        this.addUserAgent(port);
        return (T)port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceUrlFromConfig(Class serviceInterface) {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream("bingads.properties");
            if (input == null) {
                String string = null;
                return string;
            }
            Properties props = new Properties();
            props.load(input);
            String string = props.getProperty(serviceInterface.getCanonicalName() + ".url");
            return string;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ServiceFactoryImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private <T> void addUserAgent(T port) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("User-Agent", Arrays.asList("BingAdsSDKJava 10.4.6"));
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.http.request.headers", headers);
    }
}

