/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkLocationTargetBid;
import com.microsoft.bingads.bulk.entities.BulkLocationTargetWithStringLocation;
import com.microsoft.bingads.campaignmanagement.CityTargetBid;
import com.microsoft.bingads.campaignmanagement.CountryTargetBid;
import com.microsoft.bingads.campaignmanagement.MetroAreaTargetBid;
import com.microsoft.bingads.campaignmanagement.PostalCodeTargetBid;
import com.microsoft.bingads.campaignmanagement.StateTargetBid;
import java.util.List;

abstract class BulkLocationTarget<TBid extends BulkLocationTargetBid>
extends BulkLocationTargetWithStringLocation<TBid> {
    public BulkLocationTarget(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    @Override
    boolean shouldConvertPostalCodeTargetBid(PostalCodeTargetBid bid) {
        return !bid.isIsExcluded();
    }

    @Override
    void setPostalCodeBidAdditionialProperties(PostalCodeTargetBid postalCodeBid, TBid t) {
        postalCodeBid.setBidAdjustment(((BulkLocationTargetBid)t).getBidAdjustment());
    }

    @Override
    void setBulkPostalCodeBidAdditionalProperties(TBid bulkBid, PostalCodeTargetBid postalCodeTargetBid) {
        ((BulkLocationTargetBid)bulkBid).setBidAdjustment(postalCodeTargetBid.getBidAdjustment());
    }

    @Override
    boolean shouldConvertCityTargetBid(CityTargetBid bid) {
        return !bid.isIsExcluded();
    }

    @Override
    void setCityBidAdditionialProperties(CityTargetBid cityBid, TBid t) {
        cityBid.setBidAdjustment(((BulkLocationTargetBid)t).getBidAdjustment());
    }

    @Override
    void setBulkCityBidAdditionalProperties(TBid bulkBid, CityTargetBid cityTargetBid) {
        ((BulkLocationTargetBid)bulkBid).setBidAdjustment(cityTargetBid.getBidAdjustment());
    }

    @Override
    boolean shouldConvertMetroAreaTargetBid(MetroAreaTargetBid bid) {
        return !bid.isIsExcluded();
    }

    @Override
    void setMetroAreaBidAdditionialProperties(MetroAreaTargetBid metroAreaBid, TBid t) {
        metroAreaBid.setBidAdjustment(((BulkLocationTargetBid)t).getBidAdjustment());
    }

    @Override
    void setBulkMetroAreaBidAdditionalProperties(TBid bulkBid, MetroAreaTargetBid metroAreaTargetBid) {
        ((BulkLocationTargetBid)bulkBid).setBidAdjustment(metroAreaTargetBid.getBidAdjustment());
    }

    @Override
    boolean shouldConvertStateTargetBid(StateTargetBid bid) {
        return !bid.isIsExcluded();
    }

    @Override
    void setStateBidAdditionialProperties(StateTargetBid cityBid, TBid t) {
        cityBid.setBidAdjustment(((BulkLocationTargetBid)t).getBidAdjustment());
    }

    @Override
    void setBulkStateBidAdditionalProperties(TBid bulkBid, StateTargetBid stateTargetBid) {
        ((BulkLocationTargetBid)bulkBid).setBidAdjustment(stateTargetBid.getBidAdjustment());
    }

    @Override
    boolean shouldConvertCountryTargetBid(CountryTargetBid bid) {
        return !bid.isIsExcluded();
    }

    @Override
    void setCountryBidAdditionialProperties(CountryTargetBid cityBid, TBid t) {
        cityBid.setBidAdjustment(((BulkLocationTargetBid)t).getBidAdjustment());
    }

    @Override
    void setBulkCountryBidAdditionalProperties(TBid bulkBid, CountryTargetBid countryTargetBid) {
        ((BulkLocationTargetBid)bulkBid).setBidAdjustment(countryTargetBid.getBidAdjustment());
    }

    @Override
    List<TBid> convertApiToBulkBids() {
        List bulkBids = super.convertApiToBulkBids();
        for (BulkLocationTargetBid bid : bulkBids) {
            bid.setIntentOption(this.getLocation().getIntentOption());
        }
        return bulkBids;
    }

    @Override
    void reconstructSubTargets() {
        super.reconstructSubTargets();
        if (!this.getBids().isEmpty()) {
            this.getLocation().setIntentOption(((BulkLocationTargetBid)this.getBids().get(0)).getIntentOption());
        }
    }
}

