/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkSubTarget;
import com.microsoft.bingads.bulk.entities.BulkTargetBid;
import com.microsoft.bingads.campaignmanagement.LocationTarget2;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.internal.functionalinterfaces.Supplier;
import java.util.ArrayList;
import java.util.List;

abstract class BulkTargetWithLocation<TBid extends BulkTargetBid>
extends BulkSubTarget<TBid> {
    protected LocationTarget2 location;

    public BulkTargetWithLocation(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    protected <TApiBid, TTarget> void reconstructApiBids(List<TBid> bulkBids, Function<TBid, TApiBid> createBid, Supplier<TTarget> getTarget, Supplier<TTarget> createNewTarget, Consumer<TTarget> setTarget, Supplier<List<TApiBid>> getBids, Consumer<List<TApiBid>> setBids) {
        ArrayList<TApiBid> apiBidsFromFile = new ArrayList<TApiBid>();
        for (BulkTargetBid bulkBid : bulkBids) {
            apiBidsFromFile.add(createBid.apply(bulkBid));
        }
        if (apiBidsFromFile.isEmpty()) {
            return;
        }
        if (getTarget.get() == null) {
            setTarget.accept(createNewTarget.get());
            setBids.accept(new ArrayList());
        }
        List<TApiBid> targetBids = getBids.get();
        for (Object apiBid : apiBidsFromFile) {
            targetBids.add(apiBid);
        }
    }

    protected <T, TTarget> void convertBidsFromApi(List<TBid> bids, Supplier<TTarget> getTarget, Function<TTarget, List<T>> getBids, final BiConsumer<TBid, T> setAdditionalBidProperties, Function<T, Boolean> shouldConvertBid) {
        TTarget target = getTarget.get();
        if (target == null) {
            return;
        }
        List<T> rawBids = getBids.apply(target);
        if (rawBids == null) {
            return;
        }
        for (final T rawBid : rawBids) {
            if (!shouldConvertBid.apply(rawBid).booleanValue()) continue;
            Object bid = this.createAndPopulateBid(new Consumer<TBid>(){

                @Override
                public void accept(TBid t) {
                    setAdditionalBidProperties.accept(t, rawBid);
                }
            });
            bids.add(bid);
        }
    }

    protected <T> T getLocationProperty(Function<LocationTarget2, T> getFunc) {
        if (this.getLocation() == null) {
            return null;
        }
        return getFunc.apply(this.getLocation());
    }

    protected void setLocationProperty(Consumer<LocationTarget2> setAction) {
        if (this.getLocation() == null) {
            this.setLocation(new LocationTarget2());
        }
        setAction.accept(this.getLocation());
    }

    public LocationTarget2 getLocation() {
        return this.location;
    }

    public void setLocation(LocationTarget2 location) {
        this.location = location;
    }
}

