/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkEntity;
import com.microsoft.bingads.bulk.entities.BulkProductConditionCollection;
import com.microsoft.bingads.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.campaignmanagement.ArrayOfProductConditionCollection;
import com.microsoft.bingads.campaignmanagement.ProductAdExtension;
import com.microsoft.bingads.campaignmanagement.ProductConditionCollection;
import com.microsoft.bingads.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.internal.bulk.BulkStreamReader;
import com.microsoft.bingads.internal.bulk.TryResult;
import com.microsoft.bingads.internal.bulk.entities.BulkProductAdExtensionIdentifier;
import com.microsoft.bingads.internal.bulk.entities.MultiRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkProductAdExtension
extends MultiRecordBulkEntity {
    private long accountId;
    private ProductAdExtension productAdExtension;
    private final List<BulkProductConditionCollection> productConditionCollections = new ArrayList<BulkProductConditionCollection>();
    private BulkProductAdExtensionIdentifier identifier;
    private boolean hasDeleteAllRow;

    public long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public ProductAdExtension getProductAdExtension() {
        return this.productAdExtension;
    }

    public void setProductAdExtension(ProductAdExtension productAdExtension) {
        this.productAdExtension = productAdExtension;
    }

    public List<BulkProductConditionCollection> getProductConditionCollections() {
        return this.productConditionCollections;
    }

    @Override
    public List<? extends BulkEntity> getChildEntities() {
        return Collections.unmodifiableList(this.productConditionCollections);
    }

    public BulkProductAdExtension() {
    }

    public BulkProductAdExtension(BulkProductAdExtensionIdentifier identifier) {
        this();
        this.productAdExtension = new ProductAdExtension();
        this.productAdExtension.setType("ProductAdExtension");
        this.identifier = identifier;
        this.hasDeleteAllRow = AdExtensionStatus.DELETED.equals((Object)this.identifier.getStatus());
        this.productAdExtension.setId(identifier.getAdExtensionId());
        this.productAdExtension.setStatus(identifier.getStatus());
        this.productAdExtension.setVersion(identifier.getVersion());
        this.productAdExtension.setName(identifier.getName());
        this.accountId = identifier.getAccountId();
    }

    BulkProductAdExtension(BulkProductConditionCollection productCollection) {
        this(productCollection.getIdentifier());
        this.addProductCollection(productCollection);
    }

    private void addProductCollection(BulkProductConditionCollection productCollection) {
        this.productConditionCollections.add(productCollection);
        this.productAdExtension.setStoreId(productCollection.getStoreId());
        this.productAdExtension.setStoreName(productCollection.getStoreName());
    }

    @Override
    public void writeToStream(BulkObjectWriter rowWriter, boolean excludeReadonlyData) throws IOException {
        this.validatePropertyNotNull(this.productAdExtension, "ProductAdExtension");
        this.validatePropertyNotNull(this.productAdExtension.getProductSelection(), "ProductAdExtension.ProductSelection");
        BulkProductAdExtensionIdentifier extensionIdentifier = new BulkProductAdExtensionIdentifier();
        extensionIdentifier.setStatus(AdExtensionStatus.DELETED);
        extensionIdentifier.setAccountId(this.accountId);
        extensionIdentifier.setAdExtensionId(this.productAdExtension.getId());
        extensionIdentifier.setName(this.productAdExtension.getName());
        rowWriter.writeObjectRow(extensionIdentifier, excludeReadonlyData);
        for (BulkProductConditionCollection bulkProductConditionCollection : this.convertRawToBulkProductConditionCollections()) {
            bulkProductConditionCollection.writeToStream(rowWriter, excludeReadonlyData);
        }
    }

    @Override
    public void readRelatedDataFromStream(BulkStreamReader reader) {
        boolean hasMoreRows = true;
        while (hasMoreRows) {
            TryResult<BulkProductConditionCollection> nextProductCollectionResult = reader.tryRead(new Predicate<BulkProductConditionCollection>(){

                @Override
                public boolean test(BulkProductConditionCollection x) {
                    return x.getIdentifier().equals(BulkProductAdExtension.this.identifier);
                }
            }, BulkProductConditionCollection.class);
            if (nextProductCollectionResult.isSuccessful()) {
                this.addProductCollection(nextProductCollectionResult.getResult());
                continue;
            }
            TryResult<BulkProductAdExtensionIdentifier> identifierResult = reader.tryRead(new Predicate<BulkProductAdExtensionIdentifier>(){

                @Override
                public boolean test(BulkProductAdExtensionIdentifier x) {
                    return x.equals(BulkProductAdExtension.this.identifier);
                }
            }, BulkProductAdExtensionIdentifier.class);
            if (identifierResult.isSuccessful()) {
                if (!AdExtensionStatus.DELETED.equals((Object)identifierResult.getResult().getStatus())) continue;
                this.hasDeleteAllRow = true;
                continue;
            }
            hasMoreRows = false;
        }
        ArrayOfProductConditionCollection apiCollections = this.getApiCollections();
        this.productAdExtension.setProductSelection(apiCollections);
        this.productAdExtension.setStatus(apiCollections.getProductConditionCollections().size() > 0 ? AdExtensionStatus.ACTIVE : AdExtensionStatus.DELETED);
    }

    private ArrayOfProductConditionCollection getApiCollections() {
        ArrayOfProductConditionCollection apiCollections = new ArrayOfProductConditionCollection();
        for (BulkProductConditionCollection bulkCollection : this.productConditionCollections) {
            apiCollections.getProductConditionCollections().add(bulkCollection.getProductConditionCollection());
        }
        return apiCollections;
    }

    private List<BulkProductConditionCollection> convertRawToBulkProductConditionCollections() {
        ArrayList<BulkProductConditionCollection> bulkCollections = new ArrayList<BulkProductConditionCollection>();
        List<ProductConditionCollection> apiCollections = this.productAdExtension.getProductSelection().getProductConditionCollections();
        for (ProductConditionCollection apiCollection : apiCollections) {
            BulkProductConditionCollection bulkCollection = new BulkProductConditionCollection();
            bulkCollections.add(bulkCollection);
            bulkCollection.setProductConditionCollection(apiCollection);
            bulkCollection.setAccountId(this.accountId);
            bulkCollection.setAdExtensionId(this.productAdExtension.getId());
            bulkCollection.setName(this.productAdExtension.getName());
            bulkCollection.setStoreId(this.productAdExtension.getStoreId());
        }
        return bulkCollections;
    }

    @Override
    public boolean allChildrenPresent() {
        return this.hasDeleteAllRow;
    }
}

