/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkDayTimeTargetBid;
import com.microsoft.bingads.bulk.entities.BulkSubTarget;
import com.microsoft.bingads.campaignmanagement.ArrayOfDayTimeTargetBid;
import com.microsoft.bingads.campaignmanagement.DayTimeTarget;
import com.microsoft.bingads.campaignmanagement.DayTimeTargetBid;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import java.util.ArrayList;
import java.util.List;

abstract class BulkDayTimeTarget<TBid extends BulkDayTimeTargetBid>
extends BulkSubTarget<TBid> {
    private DayTimeTarget dayTimeTarget;

    public BulkDayTimeTarget(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    @Override
    void reconstructSubTargets() {
        this.setDayTimeTarget(new DayTimeTarget());
        ArrayOfDayTimeTargetBid bids = new ArrayOfDayTimeTargetBid();
        this.getDayTimeTarget().setBids(bids);
        for (BulkDayTimeTargetBid bid : this.getBids()) {
            bids.getDayTimeTargetBids().add(bid.getDayTimeTargetBid());
        }
    }

    @Override
    List<TBid> convertApiToBulkBids() {
        ArrayList<BulkDayTimeTargetBid> bulkBids = new ArrayList<BulkDayTimeTargetBid>();
        if (this.getDayTimeTarget() == null || this.getDayTimeTarget().getBids() == null) {
            return bulkBids;
        }
        for (final DayTimeTargetBid apiBid : this.getDayTimeTarget().getBids().getDayTimeTargetBids()) {
            BulkDayTimeTargetBid bulkBid = (BulkDayTimeTargetBid)this.createAndPopulateBid(new Consumer<TBid>(){

                @Override
                public void accept(TBid t) {
                    ((BulkDayTimeTargetBid)t).setDayTimeTargetBid(apiBid);
                }
            });
            bulkBids.add(bulkBid);
        }
        return bulkBids;
    }

    @Override
    void validatePropertiesNotNull() {
        this.validatePropertyNotNull(this.getDayTimeTarget(), "DayTimeTarget");
    }

    @Override
    void validateBidsNotNullOrEmpty() {
        if (this.getDayTimeTarget() != null) {
            this.validateListNotNullOrEmpty(this.getDayTimeTarget().getBids(), this.getDayTimeTarget().getBids().getDayTimeTargetBids(), "DayTimeTarget.Bids");
        }
    }

    public DayTimeTarget getDayTimeTarget() {
        return this.dayTimeTarget;
    }

    public void setDayTimeTarget(DayTimeTarget dayTimeTarget) {
        this.dayTimeTarget = dayTimeTarget;
    }
}

