/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.campaignmanagement.AdExtension;
import com.microsoft.bingads.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BulkAdExtension<T extends AdExtension>
extends SingleRecordBulkEntity {
    private Long accountId;
    private T adExtension;
    private static final List<BulkMapping<BulkAdExtension>> MAPPINGS;

    BulkAdExtension() {
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    protected T getAdExtension() {
        return this.adExtension;
    }

    protected void setAdExtension(T adExtension) {
        this.adExtension = adExtension;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdExtension, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdExtension, Object>>();
        m.add(new SimpleBulkMapping<BulkAdExtension, String>("Status", new Function<BulkAdExtension, String>(){

            @Override
            public String apply(BulkAdExtension c) {
                return StringExtensions.toAdExtensionStatusBulkString(((AdExtension)c.getAdExtension()).getStatus());
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                ((AdExtension)c.getAdExtension()).setStatus(StringExtensions.parseOptional(v, new Function<String, AdExtensionStatus>(){

                    @Override
                    public AdExtensionStatus apply(String value) {
                        return AdExtensionStatus.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, Long>("Id", new Function<BulkAdExtension, Long>(){

            @Override
            public Long apply(BulkAdExtension c) {
                return ((AdExtension)c.getAdExtension()).getId();
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                ((AdExtension)c.getAdExtension()).setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, Long>("Parent Id", new Function<BulkAdExtension, Long>(){

            @Override
            public Long apply(BulkAdExtension c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtension, Integer>("Version", new Function<BulkAdExtension, Integer>(){

            @Override
            public Integer apply(BulkAdExtension t) {
                return ((AdExtension)t.getAdExtension()).getVersion();
            }
        }, new BiConsumer<String, BulkAdExtension>(){

            @Override
            public void accept(String v, BulkAdExtension c) {
                ((AdExtension)c.getAdExtension()).setVersion(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

