/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.PerformanceData;
import com.microsoft.bingads.bulk.entities.Status;
import com.microsoft.bingads.campaignmanagement.AdExtensionEditorialStatus;
import com.microsoft.bingads.campaignmanagement.AdExtensionIdToEntityIdAssociation;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAdExtensionAssociation
extends SingleRecordBulkEntity {
    private Status status;
    private AdExtensionIdToEntityIdAssociation adExtensionIdToEntityIdAssociation;
    private PerformanceData performanceData;
    private AdExtensionEditorialStatus editorialStatus;
    private static final List<BulkMapping<BulkAdExtensionAssociation>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdExtensionIdToEntityIdAssociation(), "AdExtensionIdToEntityIdAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
        }
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAdExtensionIdToEntityIdAssociation(new AdExtensionIdToEntityIdAssociation());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData = PerformanceData.readFromRowValuesOrNull(values);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public AdExtensionEditorialStatus getEditorialStatus() {
        return this.editorialStatus;
    }

    void setEditorialStatus(AdExtensionEditorialStatus editorialStatus) {
        this.editorialStatus = editorialStatus;
    }

    public AdExtensionIdToEntityIdAssociation getAdExtensionIdToEntityIdAssociation() {
        return this.adExtensionIdToEntityIdAssociation;
    }

    public void setAdExtensionIdToEntityIdAssociation(AdExtensionIdToEntityIdAssociation adExtensionIdToEntityIdAssociation) {
        this.adExtensionIdToEntityIdAssociation = adExtensionIdToEntityIdAssociation;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdExtensionAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdExtensionAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdExtensionAssociation, String>("Status", new Function<BulkAdExtensionAssociation, String>(){

            @Override
            public String apply(BulkAdExtensionAssociation c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdExtensionAssociation>(){

            @Override
            public void accept(String v, BulkAdExtensionAssociation c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionAssociation, Long>("Id", new Function<BulkAdExtensionAssociation, Long>(){

            @Override
            public Long apply(BulkAdExtensionAssociation c) {
                return c.getAdExtensionIdToEntityIdAssociation().getAdExtensionId();
            }
        }, new BiConsumer<String, BulkAdExtensionAssociation>(){

            @Override
            public void accept(String v, BulkAdExtensionAssociation c) {
                c.getAdExtensionIdToEntityIdAssociation().setAdExtensionId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionAssociation, Long>("Parent Id", new Function<BulkAdExtensionAssociation, Long>(){

            @Override
            public Long apply(BulkAdExtensionAssociation c) {
                return c.getAdExtensionIdToEntityIdAssociation().getEntityId();
            }
        }, new BiConsumer<String, BulkAdExtensionAssociation>(){

            @Override
            public void accept(String v, BulkAdExtensionAssociation c) {
                c.getAdExtensionIdToEntityIdAssociation().setEntityId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionAssociation, String>("Editorial Status", new Function<BulkAdExtensionAssociation, String>(){

            @Override
            public String apply(BulkAdExtensionAssociation t) {
                return t.getEditorialStatus() != null ? t.getEditorialStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdExtensionAssociation>(){

            @Override
            public void accept(String v, BulkAdExtensionAssociation c) {
                c.setEditorialStatus(StringExtensions.parseOptional(v, new Function<String, AdExtensionEditorialStatus>(){

                    @Override
                    public AdExtensionEditorialStatus apply(String value) {
                        return AdExtensionEditorialStatus.fromValue(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

