/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.internal.bulk;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;

public class ConditionalBulkMapping<TEntity, TProperty>
implements BulkMapping<TEntity> {
    private SimpleBulkMapping<TEntity, TProperty> simpleMapping;
    private Function<TEntity, Boolean> condition;

    public ConditionalBulkMapping(String csvHeader, Function<TEntity, Boolean> condition, Function<TEntity, TProperty> fieldToCsv, BiConsumer<String, TEntity> csvToField) {
        this.simpleMapping = new SimpleBulkMapping<TEntity, TProperty>(csvHeader, fieldToCsv, csvToField);
        this.condition = condition;
    }

    @Override
    public void convertToCsv(TEntity entity, RowValues values) {
        if (this.condition.apply(entity).booleanValue()) {
            this.simpleMapping.convertToCsv((Object)entity, values);
        }
    }

    @Override
    public void convertToEntity(RowValues values, TEntity entity) {
        if (this.condition.apply(entity).booleanValue()) {
            this.simpleMapping.convertToEntity(values, (Object)entity);
        }
    }
}

