/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.BulkLocationTargetBidWithStringLocation;
import com.microsoft.bingads.v10.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.v10.campaignmanagement.IntentOption;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BulkLocationTargetBid
extends BulkLocationTargetBidWithStringLocation {
    private int bidAdjustment;
    private IntentOption intentOption;
    private static final List<BulkMapping<BulkLocationTargetBid>> MAPPINGS;

    BulkLocationTargetBid(BulkTargetIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public int getBidAdjustment() {
        return this.bidAdjustment;
    }

    public void setBidAdjustment(int bidAdjustment) {
        this.bidAdjustment = bidAdjustment;
    }

    public IntentOption getIntentOption() {
        return this.intentOption;
    }

    void setIntentOption(IntentOption intentOption) {
        this.intentOption = intentOption;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkLocationTargetBid, Object>> m = new ArrayList<SimpleBulkMapping<BulkLocationTargetBid, Object>>();
        m.add(new SimpleBulkMapping<BulkLocationTargetBid, Integer>("Bid Adjustment", new Function<BulkLocationTargetBid, Integer>(){

            @Override
            public Integer apply(BulkLocationTargetBid c) {
                return c.getBidAdjustment();
            }
        }, new BiConsumer<String, BulkLocationTargetBid>(){

            @Override
            public void accept(String v, BulkLocationTargetBid c) {
                c.setBidAdjustment(Integer.parseInt(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkLocationTargetBid, String>("Physical Intent", new Function<BulkLocationTargetBid, String>(){

            @Override
            public String apply(BulkLocationTargetBid c) {
                return c.getIntentOption() != null ? c.getIntentOption().value() : null;
            }
        }, new BiConsumer<String, BulkLocationTargetBid>(){

            @Override
            public void accept(String v, BulkLocationTargetBid c) {
                c.setIntentOption(StringExtensions.parseOptional(v, new Function<String, IntentOption>(){

                    @Override
                    public IntentOption apply(String value) {
                        return IntentOption.fromValue(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

