/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkTargetBid;
import com.microsoft.bingads.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.campaignmanagement.DistanceUnit;
import com.microsoft.bingads.campaignmanagement.IntentOption;
import com.microsoft.bingads.campaignmanagement.RadiusTargetBid2;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BulkRadiusTargetBid
extends BulkTargetBid {
    private RadiusTargetBid2 radiusTargetBid;
    private IntentOption intentOption;
    private static final List<BulkMapping<BulkRadiusTargetBid>> MAPPINGS;

    BulkRadiusTargetBid(BulkTargetIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setRadiusTargetBid(new RadiusTargetBid2());
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getRadiusTargetBid(), "RadiusTargetBid");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public RadiusTargetBid2 getRadiusTargetBid() {
        return this.radiusTargetBid;
    }

    public void setRadiusTargetBid(RadiusTargetBid2 radiusTargetBid) {
        this.radiusTargetBid = radiusTargetBid;
    }

    public IntentOption getIntentOption() {
        return this.intentOption;
    }

    void setIntentOption(IntentOption intentOption) {
        this.intentOption = intentOption;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkRadiusTargetBid, Object>> m = new ArrayList<SimpleBulkMapping<BulkRadiusTargetBid, Object>>();
        m.add(new SimpleBulkMapping<BulkRadiusTargetBid, Long>("Radius Target Id", new Function<BulkRadiusTargetBid, Long>(){

            @Override
            public Long apply(BulkRadiusTargetBid c) {
                return c.getRadiusTargetBid().getId();
            }
        }, new BiConsumer<String, BulkRadiusTargetBid>(){

            @Override
            public void accept(String v, BulkRadiusTargetBid c) {
                c.getRadiusTargetBid().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRadiusTargetBid, String>("Name", new Function<BulkRadiusTargetBid, String>(){

            @Override
            public String apply(BulkRadiusTargetBid c) {
                return c.getRadiusTargetBid().getName();
            }
        }, new BiConsumer<String, BulkRadiusTargetBid>(){

            @Override
            public void accept(String v, BulkRadiusTargetBid c) {
                c.getRadiusTargetBid().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkRadiusTargetBid, Double>("Radius", new Function<BulkRadiusTargetBid, Double>(){

            @Override
            public Double apply(BulkRadiusTargetBid c) {
                return c.getRadiusTargetBid().getRadius();
            }
        }, new BiConsumer<String, BulkRadiusTargetBid>(){

            @Override
            public void accept(String v, BulkRadiusTargetBid c) {
                c.getRadiusTargetBid().setRadius(Double.parseDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRadiusTargetBid, String>("Unit", new Function<BulkRadiusTargetBid, String>(){

            @Override
            public String apply(BulkRadiusTargetBid c) {
                return c.getRadiusTargetBid().getRadiusUnit() != null ? c.getRadiusTargetBid().getRadiusUnit().value() : null;
            }
        }, new BiConsumer<String, BulkRadiusTargetBid>(){

            @Override
            public void accept(String v, BulkRadiusTargetBid c) {
                c.getRadiusTargetBid().setRadiusUnit(DistanceUnit.fromValue(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRadiusTargetBid, Double>("Latitude", new Function<BulkRadiusTargetBid, Double>(){

            @Override
            public Double apply(BulkRadiusTargetBid c) {
                return c.getRadiusTargetBid().getLatitudeDegrees();
            }
        }, new BiConsumer<String, BulkRadiusTargetBid>(){

            @Override
            public void accept(String v, BulkRadiusTargetBid c) {
                c.getRadiusTargetBid().setLatitudeDegrees(Double.parseDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRadiusTargetBid, Double>("Longitude", new Function<BulkRadiusTargetBid, Double>(){

            @Override
            public Double apply(BulkRadiusTargetBid c) {
                return c.getRadiusTargetBid().getLongitudeDegrees();
            }
        }, new BiConsumer<String, BulkRadiusTargetBid>(){

            @Override
            public void accept(String v, BulkRadiusTargetBid c) {
                c.getRadiusTargetBid().setLongitudeDegrees(Double.parseDouble(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRadiusTargetBid, Integer>("Bid Adjustment", new Function<BulkRadiusTargetBid, Integer>(){

            @Override
            public Integer apply(BulkRadiusTargetBid c) {
                return c.getRadiusTargetBid().getBidAdjustment();
            }
        }, new BiConsumer<String, BulkRadiusTargetBid>(){

            @Override
            public void accept(String v, BulkRadiusTargetBid c) {
                c.getRadiusTargetBid().setBidAdjustment(Integer.parseInt(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkRadiusTargetBid, String>("Physical Intent", new Function<BulkRadiusTargetBid, String>(){

            @Override
            public String apply(BulkRadiusTargetBid c) {
                return c.getIntentOption() != null ? c.getIntentOption().value() : null;
            }
        }, new BiConsumer<String, BulkRadiusTargetBid>(){

            @Override
            public void accept(String v, BulkRadiusTargetBid c) {
                c.setIntentOption(StringExtensions.parseOptional(v, new Function<String, IntentOption>(){

                    @Override
                    public IntentOption apply(String value) {
                        return IntentOption.fromValue(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

