/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.ProductConditionHelper;
import com.microsoft.bingads.bulk.entities.Status;
import com.microsoft.bingads.campaignmanagement.ArrayOfProductCondition;
import com.microsoft.bingads.campaignmanagement.CampaignCriterion;
import com.microsoft.bingads.campaignmanagement.ProductScope;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignProductScope
extends SingleRecordBulkEntity {
    private CampaignCriterion campaignCriterion;
    private String campaignName;
    private Status status;
    private static final List<BulkMapping<BulkCampaignProductScope>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        CampaignCriterion campaignCriterion = new CampaignCriterion();
        campaignCriterion.setCriterion(new ProductScope());
        campaignCriterion.setType(CampaignCriterion.class.getSimpleName());
        campaignCriterion.getCriterion().setType(ProductScope.class.getSimpleName());
        this.setCampaignCriterion(campaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaignCriterion(), CampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public CampaignCriterion getCampaignCriterion() {
        return this.campaignCriterion;
    }

    public void setCampaignCriterion(CampaignCriterion campaignCriterion) {
        this.campaignCriterion = campaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignProductScope, String>("Status", new Function<BulkCampaignProductScope, String>(){

            @Override
            public String apply(BulkCampaignProductScope c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaignProductScope>(){

            @Override
            public void accept(String v, BulkCampaignProductScope c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProductScope, Long>("Id", new Function<BulkCampaignProductScope, Long>(){

            @Override
            public Long apply(BulkCampaignProductScope c) {
                return c.getCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignProductScope>(){

            @Override
            public void accept(String v, BulkCampaignProductScope c) {
                c.getCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProductScope, Long>("Parent Id", new Function<BulkCampaignProductScope, Long>(){

            @Override
            public Long apply(BulkCampaignProductScope c) {
                return c.getCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignProductScope>(){

            @Override
            public void accept(String v, BulkCampaignProductScope c) {
                c.getCampaignCriterion().setCampaignId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignProductScope, String>("Campaign", new Function<BulkCampaignProductScope, String>(){

            @Override
            public String apply(BulkCampaignProductScope c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignProductScope>(){

            @Override
            public void accept(String v, BulkCampaignProductScope c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaignProductScope>(new BiConsumer<BulkCampaignProductScope, RowValues>(){

            @Override
            public void accept(BulkCampaignProductScope c, RowValues v) {
                ProductScope product = (ProductScope)c.getCampaignCriterion().getCriterion();
                if (product == null || product.getConditions() == null) {
                    return;
                }
                ProductConditionHelper.addRowValuesFromConditions(product.getConditions(), v);
            }
        }, new BiConsumer<RowValues, BulkCampaignProductScope>(){

            @Override
            public void accept(RowValues v, BulkCampaignProductScope c) {
                ProductScope product = (ProductScope)c.getCampaignCriterion().getCriterion();
                product.setConditions(new ArrayOfProductCondition());
                ProductConditionHelper.addConditionsFromRowValues(v, product.getConditions());
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

