/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.internal.bulk;

import com.microsoft.bingads.v10.bulk.entities.BulkEntity;
import com.microsoft.bingads.v10.internal.bulk.EntityExtractor;
import java.util.Iterator;

public class ExtractChildEntitiesIterator
implements Iterator<BulkEntity> {
    private Iterator<? extends BulkEntity> children;
    private Iterator<BulkEntity> currentChildIterator;

    public ExtractChildEntitiesIterator(Iterator<? extends BulkEntity> children) {
        this.children = children;
    }

    @Override
    public boolean hasNext() {
        this.update();
        if (this.currentChildIterator == null) {
            return false;
        }
        return this.currentChildIterator.hasNext();
    }

    @Override
    public BulkEntity next() {
        this.update();
        if (this.currentChildIterator.hasNext()) {
            return this.currentChildIterator.next();
        }
        throw new UnsupportedOperationException();
    }

    public void update() {
        if (this.currentChildIterator == null || !this.currentChildIterator.hasNext()) {
            if (this.children.hasNext()) {
                BulkEntity nextChild = this.children.next();
                this.currentChildIterator = EntityExtractor.extractChildEntitiesIfNeeded(nextChild);
            } else {
                this.currentChildIterator = null;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

