/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk;

import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.bulk.BulkOperationInProgressException;
import com.microsoft.bingads.bulk.BulkOperationProgressInfo;
import com.microsoft.bingads.bulk.BulkOperationStatus;
import com.microsoft.bingads.bulk.IBulkService;
import com.microsoft.bingads.bulk.OperationError;
import com.microsoft.bingads.bulk.Progress;
import com.microsoft.bingads.internal.ParentCallback;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.bulk.BulkOperationStatusProvider;
import com.microsoft.bingads.internal.bulk.BulkOperationTracker;
import com.microsoft.bingads.internal.bulk.PollingBulkOperationTracker;
import com.microsoft.bingads.internal.utilities.HttpClientHttpFileService;
import com.microsoft.bingads.internal.utilities.HttpFileService;
import com.microsoft.bingads.internal.utilities.SimpleZipExtractor;
import com.microsoft.bingads.internal.utilities.ZipExtractor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.Future;

public abstract class BulkOperation<TStatus> {
    private AuthorizationData authorizationData;
    private String requestId;
    private String trackingId;
    private int statusPollIntervalInMilliseconds;
    BulkOperationStatusProvider<TStatus> statusProvider;
    private HttpFileService httpFileService;
    private ZipExtractor zipExtractor;
    private ServiceClient<IBulkService> serviceClient;
    private BulkOperationStatus<TStatus> finalStatus;

    BulkOperation(String requestId, AuthorizationData authorizationData) {
        this(requestId, authorizationData, null, null);
    }

    BulkOperation(String requestId, AuthorizationData authorizationData, BulkOperationStatusProvider<TStatus> statusProvider) {
        this(requestId, authorizationData, statusProvider, null);
    }

    BulkOperation(String requestId, AuthorizationData authorizationData, BulkOperationStatusProvider<TStatus> statusProvider, String trackingId) {
        this.statusProvider = statusProvider;
        this.requestId = requestId;
        this.authorizationData = authorizationData;
        this.trackingId = trackingId;
        this.statusPollIntervalInMilliseconds = 5000;
        this.serviceClient = new ServiceClient<IBulkService>(authorizationData, IBulkService.class);
        this.zipExtractor = new SimpleZipExtractor();
        this.httpFileService = new HttpClientHttpFileService();
    }

    public Future<BulkOperationStatus<TStatus>> trackAsync(AsyncCallback<BulkOperationStatus<TStatus>> callback) {
        return this.trackAsync(null, callback);
    }

    public Future<BulkOperationStatus<TStatus>> trackAsync(Progress<BulkOperationProgressInfo> progress, AsyncCallback<BulkOperationStatus<TStatus>> callback) {
        BulkOperationTracker<TStatus> tracker = this.generateTracker(progress);
        final ResultFuture<BulkOperationStatus<TStatus>> resultFuture = new ResultFuture<BulkOperationStatus<TStatus>>(callback);
        tracker.trackResultFileAsync(new ParentCallback<BulkOperationStatus<TStatus>>(resultFuture){

            @Override
            public void onSuccess(BulkOperationStatus<TStatus> status) {
                BulkOperation.this.finalStatus = status;
                resultFuture.setResult(BulkOperation.this.finalStatus);
            }
        });
        return resultFuture;
    }

    private BulkOperationTracker<TStatus> generateTracker(Progress<BulkOperationProgressInfo> progress) {
        PollingBulkOperationTracker<TStatus> tracker = new PollingBulkOperationTracker<TStatus>(this.statusProvider, this.serviceClient, progress, this.statusPollIntervalInMilliseconds);
        return tracker;
    }

    public Future<BulkOperationStatus<TStatus>> getStatusAsync(AsyncCallback<BulkOperationStatus<TStatus>> callback) {
        final ResultFuture<BulkOperationStatus<TStatus>> resultFuture = new ResultFuture<BulkOperationStatus<TStatus>>(callback);
        if (this.finalStatus != null) {
            resultFuture.setResult(this.finalStatus);
            return resultFuture;
        }
        this.statusProvider.getCurrentStatus(this.serviceClient, new ParentCallback<BulkOperationStatus<TStatus>>(resultFuture){

            @Override
            public void onSuccess(BulkOperationStatus<TStatus> currentStatus) {
                if (BulkOperation.this.statusProvider.isFinalStatus(currentStatus)) {
                    BulkOperation.this.finalStatus = currentStatus;
                }
                resultFuture.setResult(currentStatus);
            }
        });
        return resultFuture;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    BulkOperationStatusProvider<TStatus> getStatusProvider() {
        return this.statusProvider;
    }

    void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    void setStatusProvider(BulkOperationStatusProvider<TStatus> statusProvider) {
        this.statusProvider = statusProvider;
    }

    HttpFileService getHttpFileService() {
        return this.httpFileService;
    }

    void setHttpFileService(HttpFileService httpFileService) {
        this.httpFileService = httpFileService;
    }

    ZipExtractor getZipExtractor() {
        return this.zipExtractor;
    }

    void setZipExtractor(ZipExtractor zipExtractor) {
        this.zipExtractor = zipExtractor;
    }

    public int getStatusPollIntervalInMilliseconds() {
        return this.statusPollIntervalInMilliseconds;
    }

    public void setStatusPollIntervalInMilliseconds(int statusPollIntervalInMilliseconds) {
        this.statusPollIntervalInMilliseconds = statusPollIntervalInMilliseconds;
    }

    public Future<File> downloadResultFileAsync(File localResultDirectoryName, String localResultFileName, boolean decompress, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        return this.downloadResultFileAsync(localResultDirectoryName, localResultFileName, decompress, false, callback);
    }

    public Future<File> downloadResultFileAsync(File localResultDirectoryName, String localResultFileName, boolean decompress, boolean overwrite, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        return this.downloadResultFileAsyncImpl(localResultDirectoryName, localResultFileName, decompress, overwrite, callback);
    }

    abstract RuntimeException getOperationCouldNotBeCompletedException(List<OperationError> var1, TStatus var2);

    private Future<File> downloadResultFileAsyncImpl(final File localResultDirectoryName, final String localResultFileName, final boolean decompress, final boolean overwrite, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        if (this.finalStatus == null) {
            this.getStatusAsync(new ParentCallback<BulkOperationStatus<TStatus>>(resultFuture){

                @Override
                public void onSuccess(BulkOperationStatus<TStatus> result) throws IOException, URISyntaxException {
                    if (BulkOperation.this.finalStatus == null) {
                        resultFuture.setException(new BulkOperationInProgressException());
                        return;
                    }
                    File resultFile = BulkOperation.this.downloadFileWithFinalStatus(localResultDirectoryName, localResultFileName, decompress, overwrite);
                    resultFuture.setResult(resultFile);
                }
            });
        } else {
            File resultFile = this.downloadFileWithFinalStatus(localResultDirectoryName, localResultFileName, decompress, overwrite);
            resultFuture.setResult(resultFile);
        }
        return resultFuture;
    }

    private File downloadFileWithFinalStatus(File localResultDirectoryName, String localResultFileName, boolean decompress, boolean overwrite) throws IOException, URISyntaxException {
        if (!this.statusProvider.isSuccessStatus(this.finalStatus.getStatus())) {
            List<OperationError> errors = this.finalStatus.getErrors();
            throw this.getOperationCouldNotBeCompletedException(errors, this.finalStatus.getStatus());
        }
        String effectiveFileName = localResultFileName == null ? this.requestId : localResultFileName;
        File fullPath = new File(localResultDirectoryName, effectiveFileName);
        File zipResultPath = new File(localResultDirectoryName, effectiveFileName + ".zip");
        this.downloadResultFileZip(this.finalStatus.getResultFileUrl(), zipResultPath, overwrite);
        if (!decompress) {
            return zipResultPath;
        }
        return this.zipExtractor.extractFirstEntryToFile(zipResultPath, fullPath, localResultFileName == null, overwrite);
    }

    private File downloadResultFileZip(String url, File tempZipFile, boolean overwrite) throws IOException, URISyntaxException {
        if (this.httpFileService == null) {
            this.httpFileService = new HttpClientHttpFileService();
        }
        this.httpFileService.downloadFile(url, tempZipFile, overwrite);
        return tempZipFile;
    }
}

