/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.support;

import com.microsoft.azure.spring.data.cosmosdb.core.CosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosQueryMethod;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.PartTreeCosmosQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.CosmosEntityInformation;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.SimpleCosmosRepository;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.context.ApplicationContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class CosmosRepositoryFactory
extends RepositoryFactorySupport {
    private final ApplicationContext applicationContext;
    private final CosmosOperations cosmosOperations;

    public CosmosRepositoryFactory(CosmosOperations cosmosOperations, ApplicationContext applicationContext) {
        this.cosmosOperations = cosmosOperations;
        this.applicationContext = applicationContext;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleCosmosRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.applicationContext});
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainType) {
        return new CosmosEntityInformation(domainType);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new CosmosDbQueryLookupStrategy(this.cosmosOperations, evaluationContextProvider));
    }

    private static class CosmosDbQueryLookupStrategy
    implements QueryLookupStrategy {
        private final CosmosOperations dbOperations;

        public CosmosDbQueryLookupStrategy(CosmosOperations operations, QueryMethodEvaluationContextProvider provider) {
            this.dbOperations = operations;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            CosmosQueryMethod queryMethod = new CosmosQueryMethod(method, metadata, factory);
            Assert.notNull((Object)((Object)queryMethod), (String)"queryMethod must not be null!");
            Assert.notNull((Object)this.dbOperations, (String)"dbOperations must not be null!");
            return new PartTreeCosmosQuery(queryMethod, this.dbOperations);
        }
    }
}

