/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.config;

import com.microsoft.azure.spring.data.cosmosdb.common.ExpressionResolver;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.CosmosMappingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class CosmosConfigurationSupport {
    @Bean
    public ExpressionResolver expressionResolver(BeanFactory beanFactory) {
        return new ExpressionResolver(beanFactory);
    }

    @Bean
    public CosmosMappingContext cosmosMappingContext() throws ClassNotFoundException {
        CosmosMappingContext mappingContext = new CosmosMappingContext();
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        return mappingContext;
    }

    protected Collection<String> getMappingBasePackages() {
        Package mappingBasePackage = this.getClass().getPackage();
        return Collections.singleton(mappingBasePackage == null ? null : mappingBasePackage.getName());
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        HashSet initialEntitySet = new HashSet();
        for (String basePackage : this.getMappingBasePackages()) {
            initialEntitySet.addAll(this.scanForEntities(basePackage));
        }
        return initialEntitySet;
    }

    protected Set<Class<?>> scanForEntities(String basePackage) throws ClassNotFoundException {
        if (!StringUtils.hasText((String)basePackage)) {
            return Collections.emptySet();
        }
        HashSet initialEntitySet = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                String className = candidate.getBeanClassName();
                Assert.notNull((Object)className, (String)"Bean class name is null.");
                initialEntitySet.add(ClassUtils.forName((String)className, (ClassLoader)CosmosConfigurationSupport.class.getClassLoader()));
            }
        }
        return initialEntitySet;
    }
}

