/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.query;

import com.microsoft.azure.spring.data.cosmosdb.core.CosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosEntityMetadata;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosParameterAccessor;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosParameterParameterAccessor;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosQueryExecution;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;

public abstract class AbstractCosmosQuery
implements RepositoryQuery {
    private final CosmosQueryMethod method;
    private final CosmosOperations operations;

    public AbstractCosmosQuery(CosmosQueryMethod method, CosmosOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] parameters) {
        CosmosParameterParameterAccessor accessor = new CosmosParameterParameterAccessor(this.method, parameters);
        DocumentQuery query = this.createQuery(accessor);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String collection = ((CosmosEntityMetadata)this.method.getEntityInformation()).getCollectionName();
        CosmosQueryExecution execution = this.getExecution(accessor);
        return execution.execute(query, processor.getReturnedType().getDomainType(), collection);
    }

    private CosmosQueryExecution getExecution(CosmosParameterAccessor accessor) {
        if (this.isDeleteQuery()) {
            return new CosmosQueryExecution.DeleteExecution(this.operations);
        }
        if (this.method.isPageQuery()) {
            return new CosmosQueryExecution.PagedExecution(this.operations, accessor.getPageable());
        }
        if (this.isExistsQuery()) {
            return new CosmosQueryExecution.ExistsExecution(this.operations);
        }
        return new CosmosQueryExecution.MultiEntityExecution(this.operations);
    }

    public CosmosQueryMethod getQueryMethod() {
        return this.method;
    }

    protected abstract DocumentQuery createQuery(CosmosParameterAccessor var1);

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isExistsQuery();
}

