/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.twin;

import com.microsoft.azure.sdk.iot.device.CorrelatingMessageCallback;
import com.microsoft.azure.sdk.iot.device.InternalClient;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageSentCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.twin.DesiredPropertiesCallback;
import com.microsoft.azure.sdk.iot.device.twin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.twin.GetTwinCorrelatingMessageCallback;
import com.microsoft.azure.sdk.iot.device.twin.ReportedPropertiesUpdateCorrelatingMessageCallback;
import com.microsoft.azure.sdk.iot.device.twin.ReportedPropertiesUpdateResponse;
import com.microsoft.azure.sdk.iot.device.twin.SubscriptionAcknowledgedCallback;
import com.microsoft.azure.sdk.iot.device.twin.Twin;
import com.microsoft.azure.sdk.iot.device.twin.TwinCollection;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTwin
implements MessageCallback {
    private static final Logger log = LoggerFactory.getLogger(DeviceTwin.class);
    private final InternalClient client;
    private DesiredPropertiesCallback desiredPropertiesCallback;
    private Object desiredPropertiesUpdateCallbackContext;

    public DeviceTwin(InternalClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Client or config cannot be null");
        }
        this.client = client;
        this.client.getConfig().setDeviceTwinMessageCallback(this, null);
    }

    @Override
    public IotHubMessageResult onCloudToDeviceMessageReceived(Message message, Object callbackContext) {
        if (message.getMessageType() != MessageType.DEVICE_TWIN) {
            log.warn("Unexpected message type received. Abandoning it");
            return IotHubMessageResult.ABANDON;
        }
        IotHubTransportMessage dtMessage = (IotHubTransportMessage)message;
        if (dtMessage.getDeviceOperationType() == DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE) {
            Twin twin = Twin.createFromDesiredPropertyJson(new String(dtMessage.getBytes(), Message.DEFAULT_IOTHUB_MESSAGE_CHARSET));
            this.desiredPropertiesCallback.onDesiredPropertiesUpdated(twin, this.desiredPropertiesUpdateCallbackContext);
        }
        return IotHubMessageResult.COMPLETE;
    }

    public void getTwinAsync(final GetTwinCorrelatingMessageCallback twinCallback, Object callbackContext) {
        if (this.desiredPropertiesCallback == null) {
            throw new IllegalStateException("Must subscribe to desired properties before getting twin.");
        }
        Objects.requireNonNull(twinCallback, "Must provide a non-null callback for receiving the twin");
        IotHubTransportMessage getTwinRequestMessage = new IotHubTransportMessage(new byte[0], MessageType.DEVICE_TWIN);
        getTwinRequestMessage.setRequestId(UUID.randomUUID().toString());
        getTwinRequestMessage.setCorrelationId(getTwinRequestMessage.getRequestId());
        getTwinRequestMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_GET_REQUEST);
        getTwinRequestMessage.setCorrelatingMessageCallback(new CorrelatingMessageCallback(){

            @Override
            public void onRequestQueued(Message message, Object callbackContext) {
                twinCallback.onRequestQueued(message, callbackContext);
            }

            @Override
            public void onRequestSent(Message message, Object callbackContext) {
                twinCallback.onRequestSent(message, callbackContext);
            }

            @Override
            public void onRequestAcknowledged(Message message, Object callbackContext, IotHubClientException e) {
                twinCallback.onRequestAcknowledged(message, callbackContext, e);
            }

            @Override
            public void onResponseReceived(Message message, Object callbackContext, IotHubClientException e) {
                int status = Integer.parseInt(((IotHubTransportMessage)message).getStatus());
                Twin twin = Twin.createFromPropertiesJson(new String(message.getBytes(), Message.DEFAULT_IOTHUB_MESSAGE_CHARSET));
                twinCallback.onResponseReceived(twin, message, callbackContext, IotHubStatusCode.getIotHubStatusCode(status), e);
            }

            @Override
            public void onResponseAcknowledged(Message message, Object callbackContext) {
                twinCallback.onResponseAcknowledged(message, callbackContext);
            }
        });
        getTwinRequestMessage.setCorrelatingMessageCallbackContext(callbackContext);
        MessageSentCallback onMessageAcknowledgedCallback = (responseStatus, exception, context) -> {};
        this.client.sendEventAsync(getTwinRequestMessage, onMessageAcknowledgedCallback, null);
    }

    public void updateReportedPropertiesAsync(TwinCollection reportedProperties, final ReportedPropertiesUpdateCorrelatingMessageCallback reportedPropertiesUpdateCorrelatingMessageCallback, Object callbackContext) {
        if (this.desiredPropertiesCallback == null) {
            throw new IllegalStateException("Must subscribe to desired properties before sending reported properties.");
        }
        Objects.requireNonNull(reportedProperties, "Reported properties cannot be null");
        String serializedReportedProperties = reportedProperties.toJsonElement().toString();
        IotHubTransportMessage updateReportedPropertiesRequest = new IotHubTransportMessage(serializedReportedProperties.getBytes(StandardCharsets.UTF_8), MessageType.DEVICE_TWIN);
        updateReportedPropertiesRequest.setConnectionDeviceId(this.client.getConfig().getDeviceId());
        updateReportedPropertiesRequest.setRequestId(UUID.randomUUID().toString());
        updateReportedPropertiesRequest.setCorrelationId(updateReportedPropertiesRequest.getRequestId());
        if (reportedProperties.getVersion() != null) {
            updateReportedPropertiesRequest.setVersion(reportedProperties.getVersion());
        }
        updateReportedPropertiesRequest.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST);
        MessageSentCallback messageSentCallback = (statusCode, exception, context) -> {};
        updateReportedPropertiesRequest.setCorrelatingMessageCallback(new CorrelatingMessageCallback(){

            @Override
            public void onRequestQueued(Message message, Object callbackContext) {
                if (reportedPropertiesUpdateCorrelatingMessageCallback != null) {
                    reportedPropertiesUpdateCorrelatingMessageCallback.onRequestQueued(message, callbackContext);
                }
            }

            @Override
            public void onRequestSent(Message message, Object callbackContext) {
                if (reportedPropertiesUpdateCorrelatingMessageCallback != null) {
                    reportedPropertiesUpdateCorrelatingMessageCallback.onRequestSent(message, callbackContext);
                }
            }

            @Override
            public void onRequestAcknowledged(Message message, Object callbackContext, IotHubClientException e) {
                if (reportedPropertiesUpdateCorrelatingMessageCallback != null) {
                    reportedPropertiesUpdateCorrelatingMessageCallback.onRequestAcknowledged(message, callbackContext, e);
                }
            }

            @Override
            public void onResponseReceived(Message message, Object callbackContext, IotHubClientException e) {
                IotHubTransportMessage dtMessage = (IotHubTransportMessage)message;
                String status = dtMessage.getStatus();
                IotHubStatusCode iotHubStatus = IotHubStatusCode.ERROR;
                if (status != null) {
                    iotHubStatus = IotHubStatusCode.getIotHubStatusCode(Integer.parseInt(status));
                }
                if (reportedPropertiesUpdateCorrelatingMessageCallback != null) {
                    log.trace("Executing twin status callback for device operation twin update reported properties response with status " + (Object)((Object)iotHubStatus));
                    reportedPropertiesUpdateCorrelatingMessageCallback.onResponseReceived(message, callbackContext, iotHubStatus, new ReportedPropertiesUpdateResponse(dtMessage.getVersion()), e);
                }
            }

            @Override
            public void onResponseAcknowledged(Message message, Object callbackContext) {
                if (reportedPropertiesUpdateCorrelatingMessageCallback != null) {
                    reportedPropertiesUpdateCorrelatingMessageCallback.onResponseAcknowledged(message, callbackContext);
                }
            }
        });
        updateReportedPropertiesRequest.setCorrelatingMessageCallbackContext(callbackContext);
        this.client.sendEventAsync(updateReportedPropertiesRequest, messageSentCallback, callbackContext);
    }

    public void subscribeToDesiredPropertiesAsync(SubscriptionAcknowledgedCallback subscriptionAcknowledgedCallback, Object subscribeToDesiredPropertiesCallbackContext, DesiredPropertiesCallback desiredPropertiesCallback, Object desiredPropertiesUpdateCallbackContext) {
        Objects.requireNonNull(desiredPropertiesCallback, "Must set a non-null handler for desired property updates");
        this.desiredPropertiesCallback = desiredPropertiesCallback;
        this.desiredPropertiesUpdateCallbackContext = desiredPropertiesUpdateCallbackContext;
        IotHubTransportMessage desiredPropertiesNotificationRequest = new IotHubTransportMessage(new byte[0], MessageType.DEVICE_TWIN);
        desiredPropertiesNotificationRequest.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST);
        MessageSentCallback eventCallback = (sentMessage, exception, callbackContext) -> {
            if (subscriptionAcknowledgedCallback != null) {
                subscriptionAcknowledgedCallback.onSubscriptionAcknowledged(exception, callbackContext);
            }
        };
        this.client.sendEventAsync(desiredPropertiesNotificationRequest, eventCallback, subscribeToDesiredPropertiesCallbackContext);
    }
}

